<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Create Computer Product']); ?>
    <?php
        $options = config('computers');
?>
    <div class="flex items-center justify-between flex-wrap gap-4">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Computers</p>
            <h1 class="text-3xl font-semibold mt-2">Create Computer Product</h1>
            <p class="text-sm text-textSecondary mt-1">Define specs with curated dropdowns and set starting stock.</p>
        </div>
        <a href="<?php echo e(route('computers.index')); ?>"
           class="inline-flex items-center px-4 py-2 rounded-2xl border border-white/60 text-sm text-textSecondary hover:text-primary">
            ← Back to list
        </a>
    </div>

    <div class="glass-card rounded-3xl p-6 mt-8">
        <form action="<?php echo e(route('computers.store')); ?>" method="POST" class="space-y-5">
            <?php echo csrf_field(); ?>
            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Product ID</label>
                    <input type="text" name="product_code" value="<?php echo e(old('product_code', $nextCode)); ?>"
                           class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary" readonly>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Product Name</label>
                    <input type="text" name="name" value="<?php echo e(old('name')); ?>"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="e.g. MacBook Pro 16&quot;" required>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Display</label>
                    <select name="display" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Display</option>
                        <?php $__currentLoopData = $options['displays']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $display): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($display); ?>" <?php if(old('display') === $display): echo 'selected'; endif; ?>><?php echo e($display); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">CPU</label>
                    <select name="cpu" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select CPU</option>
                        <?php $__currentLoopData = $options['cpus']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cpu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($cpu); ?>" <?php if(old('cpu') === $cpu): echo 'selected'; endif; ?>><?php echo e($cpu); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Capacity</label>
                    <select name="capacity" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Capacity</option>
                        <?php $__currentLoopData = $options['capacities']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $capacity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($capacity); ?>" <?php if(old('capacity') === $capacity): echo 'selected'; endif; ?>><?php echo e($capacity); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">RAM</label>
                    <select name="ram" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select RAM</option>
                        <?php $__currentLoopData = $options['rams']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ram): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($ram); ?>" <?php if(old('ram') === $ram): echo 'selected'; endif; ?>><?php echo e($ram); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Storage</label>
                    <select name="storage" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Storage</option>
                        <?php $__currentLoopData = $options['storages']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $storage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($storage); ?>" <?php if(old('storage') === $storage): echo 'selected'; endif; ?>><?php echo e($storage); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Color</label>
                    <select name="color" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Color</option>
                        <?php $__currentLoopData = $options['colors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($color); ?>" <?php if(old('color') === $color): echo 'selected'; endif; ?>><?php echo e($color); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Country Code</label>
                    <select name="country_code" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Country</option>
                        <?php $__currentLoopData = $options['countries']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($country); ?>" <?php if(old('country_code') === $country): echo 'selected'; endif; ?>><?php echo e($country); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Condition</label>
                    <select name="condition" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Condition</option>
                        <?php $__currentLoopData = $options['conditions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $condition): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($condition); ?>" <?php if(old('condition') === $condition): echo 'selected'; endif; ?>><?php echo e($condition); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Activate</label>
                    <select name="status" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Status</option>
                        <?php $__currentLoopData = $options['statuses']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($status); ?>" <?php if(old('status', 'Active') === $status): echo 'selected'; endif; ?>><?php echo e($status); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Serial Number</label>
                    <input type="text" name="serial_number" value="<?php echo e(old('serial_number')); ?>" maxlength="10"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="SN (max 10)" required>
                </div>
            </div>

            <div class="grid md:grid-cols-3 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Cost</label>
                    <input type="number" step="0.01" min="0" name="cost" value="<?php echo e(old('cost')); ?>"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="0.00" required>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Tax</label>
                    <input type="number" step="0.01" min="0" name="tax" value="<?php echo e(old('tax', 0)); ?>"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="0.00">
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Stock Qty</label>
                    <input type="number" min="0" name="stock_qty" value="<?php echo e(old('stock_qty')); ?>"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="0" required>
                </div>
            </div>

            <?php if($errors->any()): ?>
                <div class="rounded-2xl border border-red-200 bg-red-50 text-sm text-red-600 px-4 py-3">
                    <ul class="list-disc list-inside space-y-1">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="flex justify-end">
                <button type="submit"
                        class="px-6 py-3 rounded-2xl bg-gradient-to-r from-primary to-primaryDark text-white shadow-lg shadow-primary/40">
                    Save Computer Product
                </button>
            </div>
        </form>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH E:\Work with client\New folder\phone_inventory_system 3\phone_inventory_system\resources\views/computers/create.blade.php ENDPATH**/ ?>