<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Sales']); ?>

    <div class="flex justify-between items-center mb-6">
        <h1 class="text-xl font-semibold">Sales</h1>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sales.create')): ?>
            <a href="<?php echo e(route('sales.create')); ?>"
               class="bg-primary text-white px-4 py-2 rounded-lg">
                + New Sale
            </a>
        <?php endif; ?>
    </div>

    <div class="bg-white p-6 rounded-xl shadow border">
        <table class="w-full text-sm">
            <thead>
                <tr class="text-left border-b text-textSecondary">
                    <th class="py-2">Invoice</th>
                    <th class="py-2">Qty</th>
                    <th class="py-2">Total</th>
                    <th class="py-2">Payment Status</th>
                    <th class="py-2">Status</th>
                    <th class="py-2">Date</th>
                    <th></th>
                </tr>
            </thead>

            <tbody>
            <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="border-b">
                    <td class="py-3 font-semibold"><?php echo e($s->invoice_number); ?></td>
                    <td><?php echo e($s->total_qty ?? 0); ?></td>
                    <td>$<?php echo e(number_format($s->total_amount, 2)); ?></td>
                    <td><?php echo e($s->payment_method); ?></td>
                    <td><?php echo e(ucfirst($s->status)); ?></td>
                    <td><?php echo e(\Illuminate\Support\Carbon::parse($s->sale_date)->format('M d, Y')); ?></td>
                    <td>
                        <a href="<?php echo e(route('sales.show', $s->id)); ?>" class="text-primary font-semibold">
                            View
                        </a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <div class="mt-4">
            <?php echo e($sales->links()); ?>

        </div>
    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH D:\Work with client\New folder\phone_inventory_system 3\phone_inventory_system\resources\views/sales/index.blade.php ENDPATH**/ ?>