<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Suppliers']); ?>

    <h1 class="text-xl font-semibold mb-6">Suppliers</h1>

    <?php if(session('status')): ?>
        <div class="mb-4 rounded-xl border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-700">
            <?php echo e(session('status')); ?>

        </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="mb-4 rounded-xl border border-red-200 bg-red-50 px-4 py-3 text-sm text-red-700">
            <ul class="list-disc list-inside">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('suppliers.create')): ?>
    <div class="bg-white p-6 rounded-xl shadow border mb-6">
        <form action="<?php echo e(route('suppliers.store')); ?>" method="POST" class="grid grid-cols-4 gap-4">
            <?php echo csrf_field(); ?>

            <input name="name" type="text" placeholder="Supplier Name"
                   class="border px-3 py-2 rounded-lg col-span-2">

            <input name="phone" type="text" placeholder="Phone"
                   class="border px-3 py-2 rounded-lg">

            <input name="email" type="text" placeholder="Email"
                   class="border px-3 py-2 rounded-lg">

            <input name="address" type="text" placeholder="Address"
                   class="border px-3 py-2 rounded-lg col-span-4">

            <button class="bg-primary text-white px-4 py-2 rounded-lg col-span-1">
                Add Supplier
            </button>
        </form>
    </div>

    <div class="bg-white p-6 rounded-xl shadow border mb-6">
        <h2 class="text-lg font-semibold mb-4">Import Suppliers</h2>
        <form action="<?php echo e(route('suppliers.import')); ?>" method="POST" enctype="multipart/form-data"
              class="space-y-4" x-data="{ fileName: '' }">
            <?php echo csrf_field(); ?>
            <label class="flex flex-col items-center justify-center gap-3 rounded-2xl border-2 border-dashed border-borderColor/70 px-6 py-8 text-center cursor-pointer hover:border-primary/60 transition">
                <div class="h-12 w-12 rounded-full bg-primary/10 text-primary flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 16V8m0 0-3 3m3-3 3 3M4 16v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-2"/>
                    </svg>
                </div>
                <div>
                    <p class="font-semibold text-textPrimary">Drop your CSV/XLSX here or click to browse</p>
                    <p class="text-sm text-textSecondary mt-1" x-text="fileName ? `Selected: ${fileName}` : 'Allowed formats: .csv, .txt, .xlsx (max 5MB)'"></p>
                </div>
                <input type="file" name="file" accept=".csv,.txt,.xlsx"
                       class="hidden" @change="fileName = $event.target.files[0]?.name || ''">
            </label>
            <div class="flex items-center justify-between flex-wrap gap-3">
                <p class="text-sm text-textSecondary">File must include columns: <span class="font-semibold text-textPrimary">name, phone, email, address</span>. First row is treated as the header.</p>
                <button class="bg-primary text-white px-5 py-2.5 rounded-xl shadow-sm hover:bg-primary/90 transition">
                    Import File
                </button>
            </div>
        </form>
    </div>
    <?php endif; ?>

    <div class="bg-white p-6 rounded-xl shadow border">

        <table class="w-full text-sm">
            <thead>
                <tr class="border-b text-textSecondary">
                    <th class="py-2">Name</th>
                    <th class="py-2">Phone</th>
                    <th class="py-2">Email</th>
                    <th class="py-2">Address</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="border-b">
                        <td class="py-3"><?php echo e($s->name); ?></td>
                        <td><?php echo e($s->phone); ?></td>
                        <td><?php echo e($s->email); ?></td>
                        <td><?php echo e($s->address); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>

        </table>

        <div class="mt-4">
            <?php echo e($suppliers->links()); ?>

        </div>

    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH D:\Work with client\New folder\phone_inventory_system 3\phone_inventory_system\resources\views/suppliers/index.blade.php ENDPATH**/ ?>