<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Create Computer Product']); ?>
    <?php
        $options = config('computers');
    ?>
    <div class="flex items-center justify-between flex-wrap gap-4">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Computers</p>
            <h1 class="text-3xl font-semibold mt-2">Create Computer Product</h1>
            <p class="text-sm text-textSecondary mt-1">Define specs, IDs, and inventory details.</p>
        </div>
        <a href="<?php echo e(route('computers.index')); ?>"
           class="inline-flex items-center px-4 py-2 rounded-2xl border border-white/60 text-sm text-textSecondary hover:text-primary">
            Back to list
        </a>
    </div>

    <div class="glass-card rounded-3xl p-6 mt-8">
        <form action="<?php echo e(route('computers.store')); ?>" method="POST" class="space-y-5">
            <?php echo csrf_field(); ?>
            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Product ID</label>
                    <input type="text" value="<?php echo e(old('product_code')); ?>"
                           class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary" readonly>
                    <p class="text-xs text-textSecondary mt-1">Auto generated on save.</p>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Description</label>
                    <input type="text" name="description" value="<?php echo e(old('description')); ?>"
                           class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary cursor-not-allowed"
                           placeholder="Auto-generated description" readonly>
                    <p class="text-xs text-textSecondary mt-1">Auto-generated from product attributes.</p>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">CodeName</label>
                    <select name="code_name" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select CodeName</option>
                        <?php $__currentLoopData = $options['code_names'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($option); ?>" <?php if(old('code_name') === $option): echo 'selected'; endif; ?>><?php echo e($option); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Product Name</label>
                    <select name="name" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Product Name</option>
                        <?php $__currentLoopData = $options['product_names'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($option); ?>" <?php if(old('name') === $option): echo 'selected'; endif; ?>><?php echo e($option); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Display</label>
                    <select name="display" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Display</option>
                        <?php $__currentLoopData = $options['displays'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($option); ?>" <?php if(old('display') === $option): echo 'selected'; endif; ?>><?php echo e($option); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">CPU</label>
                    <select name="cpu" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select CPU</option>
                        <?php $__currentLoopData = $options['cpus'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($option); ?>" <?php if(old('cpu') === $option): echo 'selected'; endif; ?>><?php echo e($option); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Capacity / Core</label>
                    <select name="capacity" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Capacity</option>
                        <?php $__currentLoopData = $options['capacities'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($option); ?>" <?php if(old('capacity') === $option): echo 'selected'; endif; ?>><?php echo e($option); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">RAM</label>
                    <select name="ram" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select RAM</option>
                        <?php $__currentLoopData = $options['rams'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($option); ?>" <?php if(old('ram') === $option): echo 'selected'; endif; ?>><?php echo e($option); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Storage</label>
                    <select name="storage" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Storage</option>
                        <?php $__currentLoopData = $options['storages'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($option); ?>" <?php if(old('storage') === $option): echo 'selected'; endif; ?>><?php echo e($option); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Color Code</label>
                    <select name="color_code" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Color Code</option>
                        <?php $__currentLoopData = $options['color_codes'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($option); ?>" <?php if(old('color_code') === $option): echo 'selected'; endif; ?>><?php echo e($option); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Color</label>
                    <select name="color" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Color</option>
                        <?php $__currentLoopData = $options['colors'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($option); ?>" <?php if(old('color') === $option): echo 'selected'; endif; ?>><?php echo e($option); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Country Code</label>
                    <select name="country_code" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Country Code</option>
                        <?php $__currentLoopData = $options['country_codes'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($option); ?>" <?php if(old('country_code') === $option): echo 'selected'; endif; ?>><?php echo e($option); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Country</label>
                    <select name="country" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Country</option>
                        <?php $__currentLoopData = $options['countries'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($option); ?>" <?php if(old('country') === $option): echo 'selected'; endif; ?>><?php echo e($option); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Condition</label>
                    <select name="condition" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Condition</option>
                        <?php $__currentLoopData = $options['conditions'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($option); ?>" <?php if(old('condition') === $option): echo 'selected'; endif; ?>><?php echo e($option); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Activate</label>
                    <select name="activate" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Activate</option>
                        <?php $__currentLoopData = $options['activates'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($option); ?>" <?php if(old('activate') === $option): echo 'selected'; endif; ?>><?php echo e($option); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Internal ID</label>
                    <input type="text" name="internal_id" value="<?php echo e(old('internal_id')); ?>"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="e.g. A13_1" required>
                </div>
            </div>

            <div class="grid md:grid-cols-3 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Stock</label>
                    <input type="number" min="0" name="stock_qty" value="<?php echo e(old('stock_qty')); ?>"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="0" required>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Cost</label>
                    <input type="number" step="0.01" min="0" name="cost" value="<?php echo e(old('cost')); ?>"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="0.00" required>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Tax</label>
                    <input type="number" step="0.01" min="0" name="tax" value="<?php echo e(old('tax', 0)); ?>"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="0.00" required>
                </div>
            </div>

            <?php if($errors->any()): ?>
                <div class="rounded-2xl border border-red-200 bg-red-50 text-sm text-red-600 px-4 py-3">
                    <ul class="list-disc list-inside space-y-1">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="flex justify-end">
                <button type="submit"
                        class="px-6 py-3 rounded-2xl bg-gradient-to-r from-primary to-primaryDark text-white shadow-lg shadow-primary/40">
                    Save Computer Product
                </button>
            </div>
        </form>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const descriptionInput = document.querySelector('input[name="description"]');
            if (!descriptionInput) {
                return;
            }

            const readValue = (selector) => {
                const field = document.querySelector(selector);
                return field ? String(field.value || '').trim() : '';
            };

            const buildDescription = () => {
                const productName = readValue('select[name="name"]');
                const display = readValue('select[name="display"]');
                const cpu = readValue('select[name="cpu"]');
                const capacity = readValue('select[name="capacity"]');
                const ram = readValue('select[name="ram"]');
                const storage = readValue('select[name="storage"]');
                const color = readValue('select[name="color"]');
                const country = readValue('select[name="country"]');
                const condition = readValue('select[name="condition"]');
                const activate = readValue('select[name="activate"]');

                const main = [productName, display].filter(Boolean).join(' ').trim();
                const specs = [
                    cpu,
                    capacity,
                    ram,
                    storage,
                    color,
                    country,
                    condition,
                    activate,
                ].filter(Boolean).join(' ').trim();

                if (main && specs) {
                    descriptionInput.value = `${main} - ${specs}`;
                } else {
                    descriptionInput.value = main || specs;
                }
            };

            [
                'select[name="name"]',
                'select[name="display"]',
                'select[name="cpu"]',
                'select[name="capacity"]',
                'select[name="ram"]',
                'select[name="storage"]',
                'select[name="color"]',
                'select[name="country"]',
                'select[name="condition"]',
                'select[name="activate"]',
            ].forEach((selector) => {
                const field = document.querySelector(selector);
                if (!field) {
                    return;
                }
                field.addEventListener('change', buildDescription);
                field.addEventListener('input', buildDescription);
            });

            buildDescription();
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH D:\Work with client\New folder\phone_inventory_system 3\phone_inventory_system\resources\views/computers/create.blade.php ENDPATH**/ ?>