<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Settings']); ?>

    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-8">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Settings</p>
            <h1 class="text-3xl font-semibold mt-2">Access & Presence</h1>
            <p class="text-sm text-textSecondary">Manage roles, permissions, and monitor user activity</p>
        </div>
        <div class="flex items-center gap-2">
            <a href="<?php echo e(route('settings.users.index')); ?>" class="px-4 py-2 rounded-2xl bg-bgLight text-textPrimary text-sm font-semibold shadow-sm">
                Manage Users
            </a>
            <a href="<?php echo e(route('settings.roles.index')); ?>" class="px-4 py-2 rounded-2xl bg-primary text-white text-sm font-semibold shadow-sm">
                Manage Roles
            </a>
        </div>
    </div>

    <div class="grid gap-6 lg:grid-cols-2">
        <div class="bg-white border border-borderColor rounded-3xl shadow-sm p-6 space-y-4">
            <div class="flex items-center justify-between">
                <h2 class="text-lg font-semibold text-textPrimary">Roles</h2>
                <span class="badge-pill bg-primary/10 text-primary text-xs"><?php echo e($roles->count()); ?> total</span>
            </div>
            <div class="space-y-3">
                <?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="flex items-center justify-between text-sm bg-bgLight/60 rounded-2xl px-4 py-3">
                        <div>
                            <p class="font-semibold text-textPrimary"><?php echo e($role->name); ?></p>
                            <p class="text-xs text-textSecondary">Users: <?php echo e($role->users_count); ?></p>
                        </div>
                        <span class="text-textSecondary text-xs uppercase tracking-wide"><?php echo e($role->guard_name); ?></span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-sm text-textSecondary">No roles defined.</p>
                <?php endif; ?>
            </div>
        </div>

        <div class="bg-white border border-borderColor rounded-3xl shadow-sm p-6 space-y-4">
            <div class="flex items-center justify-between">
                <h2 class="text-lg font-semibold text-textPrimary">Permissions</h2>
                <span class="badge-pill bg-slate-100 text-textSecondary text-xs"><?php echo e($permissions->count()); ?> total</span>
            </div>
            <div class="space-y-3 max-h-72 overflow-y-auto custom-scroll">
                <?php $__empty_1 = true; $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="flex items-center justify-between text-sm border border-borderColor/60 rounded-2xl px-4 py-3">
                        <span class="text-textPrimary"><?php echo e($permission->name); ?></span>
                        <span class="text-xs text-textSecondary">Roles: <?php echo e($permission->roles_count); ?></span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-sm text-textSecondary">No permissions configured.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="mt-8 bg-white border border-borderColor rounded-3xl shadow-sm">
        <div class="p-6 border-b border-borderColor/60 flex items-center justify-between">
            <h2 class="text-lg font-semibold text-textPrimary">Users Online</h2>
            <span class="badge-pill bg-emerald-50 text-emerald-600 text-xs">
                <?php echo e($users->where('is_online')->count()); ?> online
            </span>
        </div>
        <div class="overflow-x-auto custom-scroll">
            <table class="w-full text-sm">
                <thead class="bg-bgLight text-textSecondary uppercase text-xs tracking-wide">
                    <tr>
                        <th class="px-6 py-3 text-left">User</th>
                        <th class="px-6 py-3 text-left">Branch</th>
                        <th class="px-6 py-3 text-left">Roles</th>
                        <th class="px-6 py-3 text-center">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white">
                    <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="border-t border-borderColor/60">
                            <td class="px-6 py-4">
                                <p class="font-semibold text-textPrimary"><?php echo e($user->name); ?></p>
                                <p class="text-xs text-textSecondary"><?php echo e($user->email); ?></p>
                            </td>
                            <td class="px-6 py-4"><?php echo e($user->branch->name ?? '—'); ?></td>
                            <td class="px-6 py-4 text-textSecondary">
                                <?php echo e($user->roles->pluck('name')->implode(', ') ?: 'No roles'); ?>

                            </td>
                            <td class="px-6 py-4 text-center">
                                <?php if($user->is_online): ?>
                                    <span class="badge-pill bg-emerald-50 text-emerald-600 text-xs">Online</span>
                                <?php else: ?>
                                    <span class="badge-pill bg-slate-100 text-slate-500 text-xs">Offline</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" class="px-6 py-8 text-center text-textSecondary">No users found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH D:\Work with client\New folder\phone_inventory_system 3\phone_inventory_system\resources\views/settings/index.blade.php ENDPATH**/ ?>