<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Purchase Orders']); ?>

    <div class="flex justify-between items-center mb-6">
        <h1 class="text-xl font-semibold">Purchase Orders</h1>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchases.create')): ?>
            <a href="<?php echo e(route('purchases.create')); ?>"
               class="bg-primary text-white px-4 py-2 rounded-lg">
                + New Purchase Order
            </a>
        <?php endif; ?>
    </div>

    <div class="bg-white p-6 rounded-xl shadow border">
        <table class="w-full text-sm">
            <thead>
                <tr class="text-left text-textSecondary border-b">
                    <th class="py-2">PO Number</th>
                    <th class="py-2">Supplier</th>
                    <th class="py-2">Type</th>
                    <th class="py-2">Total</th>
                    <th class="py-2">Status</th>
                    <th class="py-2">Date</th>
                    <th></th>
                </tr>
            </thead>

            <tbody>
                <?php $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="border-b">
                        <td class="py-3 font-medium"><?php echo e($p->po_number); ?></td>
                        <td><?php echo e($p->supplier->name); ?></td>
                        <td class="capitalize"><?php echo e($p->purchase_type ?? 'phone'); ?></td>
                        <td>$<?php echo e(number_format($p->total_amount, 2)); ?></td>
                        <td>
                            <?php if($p->status == 'pending'): ?>
                                <span class="text-yellow-600">Pending</span>
                            <?php elseif($p->status == 'received'): ?>
                                <span class="text-green-600">Received</span>
                            <?php elseif($p->status == 'partial'): ?>
                                <span class="text-blue-600">Partial</span>
                            <?php else: ?>
                                <span class="text-red-600">Cancelled</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($p->purchase_date); ?></td>
                        <td>
                            <a href="<?php echo e(route('purchases.show', $p->id)); ?>"
                               class="text-primary">View</a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>

        </table>

        <div class="mt-4">
            <?php echo e($purchases->links()); ?>

        </div>

    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH D:\Work with client\New folder\phone_inventory_system 3\phone_inventory_system\resources\views/purchases/index.blade.php ENDPATH**/ ?>