<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Purchase Order '.e($purchase->po_number).'']); ?>

    <h1 class="text-xl font-semibold mb-6">Purchase Order: <?php echo e($purchase->po_number); ?></h1>

    <div class="bg-white rounded-xl shadow p-6 border mb-6">
        <p class="text-sm"><strong>Supplier:</strong> <?php echo e($purchase->supplier->name); ?></p>
        <p class="text-sm"><strong>Date:</strong> <?php echo e($purchase->purchase_date); ?></p>
        <p class="text-sm"><strong>Type:</strong> <?php echo e(ucfirst($purchase->purchase_type ?? 'phone')); ?></p>
        <p class="text-sm"><strong>Status:</strong> <?php echo e(ucfirst($purchase->status)); ?></p>
        <p class="text-sm"><strong>Total:</strong> $<?php echo e(number_format($purchase->total_amount, 2)); ?></p>
    </div>

    <div class="bg-white rounded-xl shadow p-6 border">

        <h2 class="text-lg font-semibold mb-4">Items</h2>

        <table class="w-full text-sm mb-4">
            <thead>
                <tr class="text-left border-b text-textSecondary">
                    <th class="py-2">Item</th>
                    <th class="py-2">Qty</th>
                    <th class="py-2">Cost</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $purchase->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="border-b">
                        <td class="py-3">
                            <?php if($purchase->purchase_type === 'computer'): ?>
                                <?php echo e($i->computerProduct->name ?? 'Computer'); ?>

                                <?php if($i->computerProduct?->product_code): ?>
                                    (<?php echo e($i->computerProduct->product_code); ?>)
                                <?php endif; ?>
                                <?php if($i->serial_number): ?>
                                    <span class="text-textSecondary"> · SN <?php echo e($i->serial_number); ?></span>
                                <?php endif; ?>
                            <?php else: ?>
                                <?php echo e(optional($i->variation->product)->name); ?>  
                                (<?php echo e($i->variation->color); ?> / <?php echo e($i->variation->storage); ?>)
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($i->qty); ?></td>
                        <td>$<?php echo e($i->cost_price); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <?php if($purchase->status == 'pending'): ?>
            <form action="<?php echo e(route('purchases.receive', $purchase->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <button class="bg-green-600 text-white px-4 py-2 rounded-lg">
                    Receive Items
                </button>
            </form>
        <?php endif; ?>

    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH D:\Work with client\New folder\phone_inventory_system 3\phone_inventory_system\resources\views/purchases/show.blade.php ENDPATH**/ ?>