<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'New Purchase Order']); ?>

    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Purchases</p>
            <h1 class="text-3xl font-semibold mt-2">Create Purchase Order</h1>
        </div>
        <a href="<?php echo e(route('purchases.index')); ?>" class="text-primary hover:underline text-sm"><- Back to list</a>
    </div>

    <?php
        $variationMeta = $variations->map(function ($variation) {
            return [
                'id' => $variation->id,
                'product_id' => $variation->product_id,
                'product_name' => optional($variation->product)->name,
                'sku' => $variation->sku,
                'color' => $variation->color,
                'storage' => $variation->storage,
                'serial_number' => $variation->serial_number,
            ];
        })->values();

        $computerMeta = $computerProducts->map(function ($computer) {
            return [
                'id' => $computer->id,
                'product_code' => $computer->product_code,
                'name' => $computer->name,
                'serial_number' => $computer->serial_number,
                'display' => $computer->display,
                'cpu' => $computer->cpu,
                'capacity' => $computer->capacity,
                'ram' => $computer->ram,
                'storage' => $computer->storage,
                'color' => $computer->color,
                'country_code' => $computer->country_code,
                'condition' => $computer->condition,
                'cost' => $computer->cost,
                'total_cost' => $computer->total_cost,
            ];
        })->values();

        $phoneSerialMap = $variations->mapWithKeys(function ($variation) {
            if (! $variation->serial_number) {
                return [];
            }
            return [$variation->serial_number => ['id' => $variation->id]];
        });

        $computerSerialMap = $computerProducts->mapWithKeys(function ($computer) {
            if (! $computer->serial_number) {
                return [];
            }
            return [
                $computer->serial_number => [
                    'id' => $computer->id,
                    'product_code' => $computer->product_code,
                    'name' => $computer->name,
                    'display' => $computer->display,
                    'cpu' => $computer->cpu,
                    'capacity' => $computer->capacity,
                    'ram' => $computer->ram,
                    'storage' => $computer->storage,
                    'color' => $computer->color,
                    'country_code' => $computer->country_code,
                    'condition' => $computer->condition,
                    'cost' => $computer->cost,
                    'total_cost' => $computer->total_cost,
                ],
            ];
        });

        $purchaseFormPayload = [
            'purchaseCode' => old('purchase_code', $purchaseCode),
            'sInvoiceNumber' => old('s_invoice_number', $sInvoiceNumber),
            'variations' => $variationMeta,
            'computers' => $computerMeta,
            'phoneSerialMap' => $phoneSerialMap,
            'computerSerialMap' => $computerSerialMap,
            'computerOptions' => $computerOptions,
            'nextComputerCode' => $nextComputerCode,
            'computerNames' => $computerNames,
            'oldItems' => old('items', []),
            'defaults' => [
                'tax_amount' => old('tax_amount', 0),
                'other_charges' => old('other_charges', 0),
            ],
            'oldSupplier' => old('supplier_id'),
            'purchaseType' => old('purchase_type', 'phone'),
        ];
    ?>

    <form action="<?php echo e(route('purchases.store')); ?>" method="POST" class="mt-8 space-y-6" x-data='purchaseForm(<?php echo json_encode($purchaseFormPayload, 15, 512) ?>)'>
        <?php echo csrf_field(); ?>

        <div class="space-y-6">
            <div class="glass-card rounded-3xl p-6 space-y-5">
                <div class="space-y-1">
                    <h2 class="text-lg font-semibold">Information</h2>
                    <p class="text-sm text-textSecondary">Capture supplier orders and track inbound stock.</p>
                </div>

                <div class="grid md:grid-cols-3 gap-4">
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Purchase ID</label>
                        <input type="text"
                               value="<?php echo e(old('purchase_code', $purchaseCode)); ?>"
                               x-bind:value="purchaseCode"
                               readonly
                               class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary">
                        <input type="hidden" name="purchase_code" value="<?php echo e(old('purchase_code', $purchaseCode)); ?>" x-bind:value="purchaseCode">
                        <p class="text-xs text-textSecondary mt-1">Auto generated from current datetime.</p>
                    </div>
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Invoice Number</label>
                        <input type="text" name="invoice_number" value="<?php echo e(old('invoice_number')); ?>"
                               class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                               placeholder="Optional supplier invoice">
                    </div>
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">S-Invoice</label>
                        <input type="text"
                               value="<?php echo e(old('s_invoice_number', $sInvoiceNumber)); ?>"
                               x-bind:value="sInvoiceNumber"
                               readonly
                               class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary">
                        <input type="hidden" name="s_invoice_number" value="<?php echo e(old('s_invoice_number', $sInvoiceNumber)); ?>" x-bind:value="sInvoiceNumber">
                        <p class="text-xs text-textSecondary mt-1">Format: YearMonthDayHourMinute.</p>
                    </div>
                </div>

                <div class="grid md:grid-cols-3 gap-4">
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Supplier</label>
                        <select name="supplier_id"
                                x-model="supplierId"
                                class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                required>
                            <option value="">Select supplier</option>
                            <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($supplier->id); ?>" <?php if(old('supplier_id') == $supplier->id): echo 'selected'; endif; ?>><?php echo e($supplier->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($suppliers->isEmpty()): ?>
                            <p class="text-xs text-red-500 mt-2">Add a supplier first to create purchase orders.</p>
                        <?php endif; ?>
                        <p class="text-xs text-textSecondary mt-1" x-show="supplierId">
                            Supplier ID: <span class="font-semibold" x-text="supplierId"></span>
                        </p>
                    </div>
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Purchase Date</label>
                        <input type="date" name="purchase_date" value="<?php echo e(now()->toDateString()); ?>"
                               class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                    </div>
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Purchase Type</label>
                        <select name="purchase_type"
                                x-model="purchaseType"
                                @change="resetItemsForType"
                                class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                required>
                            <option value="">Select type</option>
                            <option value="computer" <?php if(old('purchase_type') === 'computer'): echo 'selected'; endif; ?>>Computer</option>
                            <option value="phone" <?php if(old('purchase_type') === 'phone'): echo 'selected'; endif; ?>>Phone</option>
                        </select>
                    </div>
                </div>
            </div>

            <div class="glass-card rounded-3xl p-6 space-y-4">
                <div class="flex items-center justify-between">
                    <div>
                        <h2 class="text-lg font-semibold">Product Details</h2>
                        <p class="text-sm text-textSecondary">Add each SKU, quantity, and cost.</p>
                    </div>
                    <button type="button" class="px-4 py-2 rounded-2xl bg-primary text-white text-sm shadow shadow-primary/30" @click="addItem">
                        + Add Item
                    </button>
                </div>

                <template x-for="(item, index) in items" :key="item.uid">
                    <div class="rounded-2xl border border-white/60 bg-white/75 p-4 space-y-4">
                        <div class="flex items-start justify-between gap-4">
                            <div class="flex-1 space-y-4">
                                <template x-if="purchaseType === 'phone'">
                                    <div class="space-y-3">
                                        <div class="grid md:grid-cols-2 gap-3" x-show="!item.locked_specs">
                                            <div>
                                                <label class="text-sm text-textSecondary font-medium mb-1 block">Product / SKU</label>
                                                <select x-model="item.variation_id"
                                                        :name="`items[${index}][variation_id]`"
                                                        @change="syncSelection(item)"
                                                        class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                                        :required="purchaseType === 'phone'">
                                                    <option value="">Select SKU</option>
                                                    <?php $__currentLoopData = $variations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($variation->id); ?>">
                                                            <?php echo e(optional($variation->product)->name ?? 'Product #'.$variation->product_id); ?> - SKU <?php echo e($variation->sku); ?>

                                                            <?php if($variation->color || $variation->storage): ?>
                                                                (<?php echo e(collect([$variation->color, $variation->storage])->filter()->join(' / ')); ?>)
                                                            <?php endif; ?>
                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <p class="text-xs text-textSecondary mt-1" x-show="item.product_id">
                                                    Product ID:
                                                    <span class="font-semibold" x-text="item.product_id"></span>
                                                </p>
                                            </div>
                                            <div>
                                                <label class="text-sm text-textSecondary font-medium mb-1 block">Serial Number (SN)</label>
                                                <input type="text"
                                                       x-model="item.serial_number"
                                                       list="phone-serials"
                                                       @change="handleSerialInput(item)"
                                                       :name="`items[${index}][serial_number]`"
                                                       class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                                       placeholder="Select or search serial">
                                            </div>
                                        </div>
                                        <div class="grid md:grid-cols-2 gap-3" x-show="item.locked_specs">
                                            <div>
                                                <label class="text-sm text-textSecondary font-medium mb-1 block">Product ID</label>
                                                <input type="text"
                                                       x-model="item.product_id"
                                                       readonly
                                                       class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary">
                                                <input type="hidden" :name="`items[${index}][variation_id]`" x-bind:value="item.variation_id">
                                            </div>
                                            <div>
                                                <label class="text-sm text-textSecondary font-medium mb-1 block">Serial Number (SN)</label>
                                                <input type="text"
                                                       x-model="item.serial_number"
                                                       list="phone-serials"
                                                       @change="handleSerialInput(item)"
                                                       :name="`items[${index}][serial_number]`"
                                                       class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                                       placeholder="Enter new serial">
                                            </div>
                                        </div>
                                        <div class="rounded-2xl border border-white/60 bg-white/70 px-4 py-3" x-show="item.details">
                                            <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">SKU</p>
                                            <p class="font-semibold" x-text="item.details?.sku || '-'"></p>
                                            <p class="text-xs uppercase tracking-[0.2em] text-textSecondary mt-2">Color / Storage</p>
                                            <p class="font-medium" x-text="formatVariant(item.details)"></p>
                                        </div>
                                        <div x-show="item.locked_specs">
                                            <input type="hidden" :name="`items[${index}][qty]`" x-bind:value="item.qty">
                                            <input type="hidden" :name="`items[${index}][cost_price]`" x-bind:value="item.cost_price">
                                        </div>
                                    </div>
                                </template>

                                <template x-if="purchaseType === 'computer'">
                                    <div class="space-y-4" x-show="!item.locked_specs">
                                        <div class="grid md:grid-cols-3 gap-3">
                                            <div>
                                                <label class="text-sm text-textSecondary font-medium mb-1 block">Product ID</label>
                                                <input type="text"
                                                       x-model="item.product_code"
                                                       readonly
                                                       class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary">
                                                <input type="hidden" :name="`items[${index}][product_code]`" x-bind:value="item.product_code">
                                                <p class="text-xs text-textSecondary mt-1">Auto generated per line item.</p>
                                            </div>
                                            <div>
                                                <label class="text-sm text-textSecondary font-medium mb-1 block">Product Name</label>
                                                <input type="text"
                                                       x-model="item.name"
                                                       list="computer-names"
                                                       :name="`items[${index}][name]`"
                                                       class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                                       placeholder="Select or type product name"
                                                       required>
                                            </div>
                                            <div>
                                                <label class="text-sm text-textSecondary font-medium mb-1 block">Serial Number (SN)</label>
                                                <input type="text"
                                                       x-model="item.serial_number"
                                                       @change="handleComputerSerialInput(item)"
                                                       :name="`items[${index}][serial_number]`"
                                                       class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                                       placeholder="Unique per device"
                                                       required>
                                            </div>
                                        </div>
                                        <div class="grid md:grid-cols-3 gap-3">
                                            <div>
                                                <label class="text-sm text-textSecondary font-medium mb-1 block">Display</label>
                                                <select x-model="item.display"
                                                        :name="`items[${index}][display]`"
                                                        class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                                        required>
                                                    <option value="">Select display</option>
                                                    <template x-for="display in computerOptions.displays" :key="display">
                                                        <option :value="display" x-text="display"></option>
                                                    </template>
                                                </select>
                                            </div>
                                            <div>
                                                <label class="text-sm text-textSecondary font-medium mb-1 block">Chip / CPU</label>
                                                <select x-model="item.cpu"
                                                        :name="`items[${index}][cpu]`"
                                                        class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                                        required>
                                                    <option value="">Select chip</option>
                                                    <template x-for="cpu in computerOptions.cpus" :key="cpu">
                                                        <option :value="cpu" x-text="cpu"></option>
                                                    </template>
                                                </select>
                                            </div>
                                            <div>
                                                <label class="text-sm text-textSecondary font-medium mb-1 block">Capacity</label>
                                                <select x-model="item.capacity"
                                                        :name="`items[${index}][capacity]`"
                                                        class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                                        required>
                                                    <option value="">Select capacity</option>
                                                    <template x-for="capacity in computerOptions.capacities" :key="capacity">
                                                        <option :value="capacity" x-text="capacity"></option>
                                                    </template>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="grid md:grid-cols-3 gap-3">
                                            <div>
                                                <label class="text-sm text-textSecondary font-medium mb-1 block">RAM</label>
                                                <select x-model="item.ram"
                                                        :name="`items[${index}][ram]`"
                                                        class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                                        required>
                                                    <option value="">Select RAM</option>
                                                    <template x-for="ram in computerOptions.rams" :key="ram">
                                                        <option :value="ram" x-text="ram"></option>
                                                    </template>
                                                </select>
                                            </div>
                                            <div>
                                                <label class="text-sm text-textSecondary font-medium mb-1 block">Storage</label>
                                                <select x-model="item.storage"
                                                        :name="`items[${index}][storage]`"
                                                        class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                                        required>
                                                    <option value="">Select storage</option>
                                                    <template x-for="storage in computerOptions.storages" :key="storage">
                                                        <option :value="storage" x-text="storage"></option>
                                                    </template>
                                                </select>
                                            </div>
                                            <div>
                                                <label class="text-sm text-textSecondary font-medium mb-1 block">Color</label>
                                                <select x-model="item.color"
                                                        :name="`items[${index}][color]`"
                                                        class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                                        required>
                                                    <option value="">Select color</option>
                                                    <template x-for="color in computerOptions.colors" :key="color">
                                                        <option :value="color" x-text="color"></option>
                                                    </template>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="grid md:grid-cols-3 gap-3">
                                            <div>
                                                <label class="text-sm text-textSecondary font-medium mb-1 block">Country Code</label>
                                                <select x-model="item.country_code"
                                                        :name="`items[${index}][country_code]`"
                                                        class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                                        required>
                                                    <option value="">Select country</option>
                                                    <template x-for="country in computerOptions.countries" :key="country">
                                                        <option :value="country" x-text="country"></option>
                                                    </template>
                                                </select>
                                            </div>
                                            <div>
                                                <label class="text-sm text-textSecondary font-medium mb-1 block">Condition</label>
                                                <select x-model="item.condition"
                                                        :name="`items[${index}][condition]`"
                                                        class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                                        required>
                                                    <option value="">Select condition</option>
                                                    <template x-for="condition in computerOptions.conditions" :key="condition">
                                                        <option :value="condition" x-text="condition"></option>
                                                    </template>
                                                </select>
                                            </div>
                                            <div class="rounded-2xl border border-white/60 bg-white/70 px-4 py-3">
                                                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Snapshot</p>
                                                <p class="font-semibold" x-text="item.name || 'Product details'"></p>
                                                <p class="text-sm text-textSecondary" x-text="buildComputerSummary(item)"></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="space-y-3" x-show="item.locked_specs">
                                        <div class="rounded-2xl border-2 border-dashed border-primary/50 bg-primary/5 p-4 space-y-3">
                                            <p class="text-xs uppercase tracking-[0.2em] text-primary font-semibold">New Serial Only</p>
                                            <div class="grid md:grid-cols-2 gap-3">
                                                <div>
                                                    <label class="text-sm text-textSecondary font-medium mb-1 block">Product ID</label>
                                                    <input type="text"
                                                           x-model="item.product_code"
                                                           readonly
                                                           class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary">
                                                    <input type="hidden" :name="`items[${index}][product_code]`" x-bind:value="item.product_code">
                                                    <p class="text-xs text-textSecondary mt-1">Same specs as previous item.</p>
                                                </div>
                                                <div>
                                                    <label class="text-sm text-textSecondary font-medium mb-1 block">Serial Number (SN)</label>
                                                    <input type="text"
                                                           x-model="item.serial_number"
                                                           @change="handleComputerSerialInput(item)"
                                                           :name="`items[${index}][serial_number]`"
                                                           class="w-full rounded-2xl border border-primary/60 bg-white px-4 py-3 focus:ring-primary/40 focus:border-primary/70"
                                                           autofocus
                                                           placeholder="Enter serial for this unit"
                                                           required>
                                                </div>
                                            </div>
                                            <p class="text-xs text-textSecondary">All other details are carried over automatically.</p>
                                        </div>
                                        <!-- Preserve other fields without editing -->
                                        <input type="hidden" :name="`items[${index}][product_code]`" x-bind:value="item.product_code">
                                        <input type="hidden" :name="`items[${index}][qty]`" x-bind:value="item.qty">
                                        <input type="hidden" :name="`items[${index}][cost_price]`" x-bind:value="item.cost_price">
                                        <template x-for="field in ['name','display','cpu','capacity','ram','storage','color','country_code','condition']" :key="field">
                                            <input type="hidden" :name="`items[${index}][${field}]`" :value="item[field]">
                                        </template>
                                    </div>
                                </template>
                            </div>
                            <div class="flex items-center gap-3">
                                <button type="button" class="text-sm text-primary hover:underline" @click="duplicateItem(index)">
                                    + Add SN
                                </button>
                                <button type="button" class="text-sm text-red-500 hover:underline" @click="removeItem(index)" x-show="items.length > 1">
                                    Remove
                                </button>
                            </div>
                        </div>

                        <div class="grid md:grid-cols-3 gap-4" x-show="!item.locked_specs">
                            <div>
                                <label class="text-sm text-textSecondary font-medium mb-1 block">Quantity</label>
                                <input type="number" min="1"
                                       x-model.number="item.qty"
                                       :name="`items[${index}][qty]`"
                                       class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                       required>
                            </div>
                            <div>
                                <label class="text-sm text-textSecondary font-medium mb-1 block">Cost Price</label>
                                <input type="number" min="0" step="0.01"
                                       x-model.number="item.cost_price"
                                       :name="`items[${index}][cost_price]`"
                                       class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                       required>
                            </div>
                            <div class="md:col-span-1">
                                <label class="text-sm text-textSecondary font-medium mb-1 block">Product Snapshot</label>
                                <div class="rounded-2xl border border-white/60 bg-white/70 px-4 py-3 space-y-1" x-show="itemSummary(item)">
                                    <p class="font-semibold" x-text="summaryTitle(item)"></p>
                                    <p class="text-sm text-textSecondary" x-text="itemSummary(item)"></p>
                                </div>
                                <div class="rounded-2xl border border-white/60 bg-white/60 px-4 py-3 text-sm text-textSecondary" x-show="!itemSummary(item)">
                                    Complete the fields above to view details.
                                </div>
                            </div>
                        </div>
                    </div>
                </template>

                <?php if($errors->any()): ?>
                    <div class="rounded-2xl bg-red-50 border border-red-200 text-sm text-red-600 px-4 py-3">
                        <ul class="list-disc list-inside space-y-1">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>

            <div class="glass-card rounded-3xl p-6 space-y-5">
                <h2 class="text-lg font-semibold">Summary</h2>
                <div class="flex items-center justify-between">
                    <span class="text-textSecondary">Line Items</span>
                    <span class="font-semibold" x-text="items.length"></span>
                </div>
                <div class="space-y-3">
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Tax</label>
                        <input type="number" min="0" step="0.01"
                               name="tax_amount"
                               x-model.number="taxAmount"
                               value="<?php echo e(old('tax_amount', 0)); ?>"
                               class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                               placeholder="0.00">
                    </div>
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Other Charges</label>
                        <input type="number" min="0" step="0.01"
                               name="other_charges"
                               x-model.number="otherCharges"
                               value="<?php echo e(old('other_charges', 0)); ?>"
                               class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                               placeholder="0.00">
                    </div>
                    <div class="rounded-2xl bg-white/70 border border-white/60 px-4 py-3">
                        <p class="text-sm text-textSecondary">Total Amount</p>
                        <p class="text-2xl font-semibold" x-text="formatCurrency(totalAmount)"></p>
                    </div>
                    <div class="rounded-2xl bg-primary/10 border border-primary/30 px-4 py-3">
                        <p class="text-sm text-textSecondary">Total Amount Due</p>
                        <p class="text-2xl font-semibold" x-text="formatCurrency(totalDue)"></p>
                    </div>
                    <input type="hidden" name="total_due" value="<?php echo e(old('total_due', 0)); ?>" x-bind:value="totalDue.toFixed(2)">
                </div>
            </div>

            <div class="flex justify-end">
                <button type="submit"
                        class="px-8 py-3 rounded-2xl bg-gradient-to-r from-primary to-primaryDark text-white shadow-lg shadow-primary/40">
                    Save Purchase Order
                </button>
            </div>
        </div>
    </form>

    <datalist id="phone-serials">
        <?php $__currentLoopData = $variations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($variation->serial_number): ?>
                <option value="<?php echo e($variation->serial_number); ?>">
                    <?php echo e(optional($variation->product)->name ?? 'Product #'.$variation->product_id); ?>

                </option>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </datalist>

    <datalist id="computer-serials">
        <?php $__currentLoopData = $computerProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $computer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($computer->serial_number): ?>
                <option value="<?php echo e($computer->serial_number); ?>"><?php echo e($computer->name); ?></option>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </datalist>

    <datalist id="computer-names">
        <?php $__currentLoopData = $computerNames; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($name); ?>"></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </datalist>


    <?php $__env->startPush('scripts'); ?>
        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.data('purchaseForm', (payload = {}) => {
                    const defaults = payload.defaults || {};
                    return {
                        purchaseType: payload.purchaseType || 'phone',
                        purchaseCode: payload.purchaseCode || '',
                        sInvoiceNumber: payload.sInvoiceNumber || '',
                        supplierId: payload.oldSupplier || '',
                        variationMeta: payload.variations || [],
                        computerMeta: payload.computers || [],
                        computerOptions: payload.computerOptions || {},
                        computerNames: payload.computerNames || [],
                        phoneSerialMap: payload.phoneSerialMap || {},
                        computerSerialMap: payload.computerSerialMap || {},
                        nextComputerCode: payload.nextComputerCode || 'MB-001',
                        computerCodeCounter: 1,
                        taxAmount: Number(defaults.tax_amount ?? 0),
                        otherCharges: Number(defaults.other_charges ?? 0),
                        items: [],
                        init() {
                            const baseComputerCode = this.extractComputerNumber(this.nextComputerCode);
                            this.computerCodeCounter = baseComputerCode;
                            const previousItems = Array.isArray(payload.oldItems) ? payload.oldItems : [];
                            if (previousItems.length) {
                                this.items = previousItems.map(item => this.hydrateItem(item));
                            } else {
                                this.items = [this.newItem()];
                            }

                            if (this.purchaseType === 'computer') {
                                const maxFromItems = this.items.reduce((max, item) => {
                                    return Math.max(max, this.extractComputerNumber(item.product_code));
                                }, 0);
                                this.computerCodeCounter = Math.max(baseComputerCode, maxFromItems + 1);
                            }

                            this.$watch('purchaseType', () => this.resetItemsForType());
                        },
                        uid() {
                            return (Date.now().toString(36) + Math.random().toString(36).slice(2, 7));
                        },
                        extractComputerNumber(code) {
                            const match = String(code || '').match(/(\d+)$/);
                            return match ? Number(match[1]) : 1;
                        },
                        generateComputerCode() {
                            const code = `MB-${String(this.computerCodeCounter).padStart(3, '0')}`;
                            this.computerCodeCounter += 1;
                            return code;
                        },
                        hydrateItem(data) {
                            if (this.purchaseType === 'computer' || data.product_code) {
                                return this.hydrateComputerItem(data);
                            }
                            return this.hydratePhoneItem(data);
                        },
                        hydratePhoneItem(data) {
                            const variationId = data.variation_id ?? '';
                            const meta = this.lookupPhoneMeta(variationId);
                            return {
                                uid: this.uid(),
                                variation_id: variationId,
                                qty: Number(data.qty ?? 1),
                                cost_price: Number(data.cost_price ?? 0),
                                serial_number: data.serial_number ?? '',
                                product_id: meta?.product_id || null,
                                details: meta || null,
                                locked_specs: Boolean(data.locked_specs || false),
                            };
                        },
                        hydrateComputerItem(data) {
                            return {
                                uid: this.uid(),
                                product_code: data.product_code || this.generateComputerCode(),
                                name: data.name || '',
                                display: data.display || '',
                                cpu: data.cpu || '',
                                capacity: data.capacity || '',
                                ram: data.ram || '',
                                storage: data.storage || '',
                                color: data.color || '',
                                country_code: data.country_code || '',
                                condition: data.condition || '',
                                serial_number: data.serial_number || '',
                                qty: Number(data.qty ?? 1),
                                cost_price: Number(data.cost_price ?? 0),
                                locked_specs: Boolean(data.locked_specs || false),
                            };
                        },
                        newItem() {
                            return this.purchaseType === 'computer' ? this.newComputerItem() : this.newPhoneItem();
                        },
                        newPhoneItem() {
                            return {
                                uid: this.uid(),
                                variation_id: '',
                                qty: 1,
                                cost_price: 0,
                                serial_number: '',
                                product_id: null,
                                details: null,
                                locked_specs: false,
                            };
                        },
                        newComputerItem(clone = null, preserveCode = false, forceUnlocked = false) {
                            const base = clone ? { ...clone } : {};
                            return {
                                uid: this.uid(),
                                product_code: (preserveCode && base.product_code) ? base.product_code : this.generateComputerCode(),
                                name: base.name || '',
                                display: base.display || '',
                                cpu: base.cpu || '',
                                capacity: base.capacity || '',
                                ram: base.ram || '',
                                storage: base.storage || '',
                                color: base.color || '',
                                country_code: base.country_code || '',
                                condition: base.condition || '',
                                serial_number: '',
                                qty: Number(base.qty ?? 1),
                                cost_price: Number(base.cost_price ?? 0),
                                locked_specs: forceUnlocked ? false : Boolean(base.locked_specs || false),
                            };
                        },
                        lookupPhoneMeta(variationId) {
                            if (!variationId) {
                                return null;
                            }
                            return this.variationMeta.find(v => String(v.id) === String(variationId)) || null;
                        },
                        syncSelection(item) {
                            if (this.purchaseType !== 'phone') return;
                            const meta = this.lookupPhoneMeta(item.variation_id);
                            item.product_id = meta?.product_id || null;
                            item.details = meta || null;
                        },
                        lookupComputerMeta(serialNumber) {
                            if (!serialNumber) return null;
                            return this.computerSerialMap[serialNumber] || this.computerMeta.find(c => String(c.serial_number) === String(serialNumber)) || null;
                        },
                        applyComputerMeta(item, meta) {
                            if (!meta) return;
                            item.name = meta.name || item.name;
                            item.display = meta.display || item.display;
                            item.cpu = meta.cpu || item.cpu;
                            item.capacity = meta.capacity || item.capacity;
                            item.ram = meta.ram || item.ram;
                            item.storage = meta.storage || item.storage;
                            item.color = meta.color || item.color;
                            item.country_code = meta.country_code || item.country_code;
                            item.condition = meta.condition || item.condition;
                            if (!item.product_code) {
                                item.product_code = this.generateComputerCode();
                            }
                            if (meta.cost !== undefined) {
                                item.cost_price = Number(meta.cost);
                            } else if (meta.total_cost !== undefined) {
                                item.cost_price = Number(meta.total_cost);
                            }
                        },
                        handleSerialInput(item) {
                            if (this.purchaseType !== 'phone') {
                                return;
                            }
                            const record = this.phoneSerialMap[item.serial_number];
                            item.variation_id = record ? record.id : '';
                            this.syncSelection(item);
                        },
                        handleComputerSerialInput(item) {
                            if (this.purchaseType !== 'computer') return;
                            if (!item.serial_number) return;
                            // Prevent reusing a serial within the same PO; specs stay as entered.
                            const duplicate = this.items.find((it) => it.uid !== item.uid && it.serial_number === item.serial_number);
                            if (duplicate) {
                                alert('This serial number is already used in this purchase order.');
                                item.serial_number = '';
                            }
                        },
                        addItem() {
                            if (this.purchaseType === 'computer') {
                                const last = this.items[this.items.length - 1];
                                const clone = last ? { ...last, locked_specs: false } : null;
                                this.items.push(this.newComputerItem(clone, false,false));
                                return;
                            }

                            this.items.push(this.newPhoneItem());
                        },
                        duplicateItem(index) {
                            const current = this.items[index];
                            if (!current) return;

                            if (this.purchaseType === 'computer') {
                                const clone = { ...current };
                                clone.serial_number = '';
                                // Keep original qty/cost; user only enters new SN.
                                clone.qty = Number(current.qty ?? 1);
                                clone.cost_price = Number(current.cost_price ?? 0);
                                clone.locked_specs = true; // only SN entry for subsequent units
                                // New product code per SN to satisfy unique computer products.
                                this.items.splice(index + 1, 0, this.newComputerItem(clone, false, false));
                                return;
                            }

                            const clone = {
                                ...current,
                                uid: this.uid(),
                                serial_number: '',
                                qty: 1,
                                cost_price: Number(current.cost_price ?? 0),
                                locked_specs: true,
                            };
                            this.items.splice(index + 1, 0, clone);
                        },
                        removeItem(index) {
                            if (this.items.length === 1) return;
                            this.items.splice(index, 1);
                        },
                        resetItemsForType() {
                            if (this.purchaseType === 'computer') {
                                this.computerCodeCounter = this.extractComputerNumber(this.nextComputerCode);
                                this.items = [this.newComputerItem()];
                            } else {
                                this.items = [this.newPhoneItem()];
                            }
                        },
                        formatCurrency(value) {
                            const number = Number(value) || 0;
                            return new Intl.NumberFormat('en-US', {
                                style: 'currency',
                                currency: 'USD'
                            }).format(number);
                        },
                        formatVariant(details) {
                            if (!details) return '-';
                            return [details.color, details.storage].filter(Boolean).join(' / ') || '-';
                        },
                        buildComputerSummary(item) {
                            if (!item) return '';
                            const parts = [
                                [item.display, item.cpu].filter(Boolean).join(' / '),
                                [item.capacity, item.ram, item.storage].filter(Boolean).join(' / '),
                                item.color,
                                item.condition,
                            ].filter(Boolean);
                            return parts.join(' | ');
                        },
                        buildPhoneSummary(item) {
                            const details = item?.details;
                            if (!details) return '';
                            const parts = [
                                details.sku ? `SKU ${details.sku}` : null,
                                this.formatVariant(details),
                            ].filter(Boolean);
                            return parts.join(' | ');
                        },
                        itemSummary(item) {
                            return this.purchaseType === 'computer'
                                ? this.buildComputerSummary(item)
                                : this.buildPhoneSummary(item);
                        },
                        summaryTitle(item) {
                            return this.purchaseType === 'computer'
                                ? (item.name || item.product_code || 'Product details')
                                : (item.details?.product_name || 'Product details');
                        },
                        get totalAmount() {
                            return this.items.reduce((total, item) => {
                                return total + ((Number(item.qty) || 0) * (Number(item.cost_price) || 0));
                            }, 0);
                        },
                        get totalDue() {
                            return this.totalAmount + (Number(this.taxAmount) || 0) + (Number(this.otherCharges) || 0);
                        }
                    };
                });
            });
        </script>
    <?php $__env->stopPush(); ?>


 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH E:\Work with client\New folder\phone_inventory_system 3\phone_inventory_system\resources\views/purchases/create.blade.php ENDPATH**/ ?>