<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Products']); ?>

    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Catalog</p>
            <h1 class="text-3xl font-semibold mt-2">Product Library</h1>
            <p class="text-sm text-textSecondary mt-1">Manage sellable devices and their variations</p>
        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.create')): ?>
        <a href="<?php echo e(route('products.create')); ?>"
           class="inline-flex items-center gap-2 px-5 py-3 rounded-2xl bg-gradient-to-r from-primary to-primaryDark text-white shadow-lg shadow-primary/40 transition hover:translate-y-0.5">
            <span>＋</span>
            New Product
        </a>
        <?php endif; ?>
    </div>

    <div class="glass-card rounded-3xl p-0 overflow-hidden mt-8">
        <?php if(session('success')): ?>
            <div class="px-6 py-4 border-b border-white/60 bg-emerald-50 text-emerald-700 text-sm">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <div class="px-6 py-5 border-b border-white/60 bg-white/80">
            <form action="<?php echo e(route('products.import')); ?>" method="POST" enctype="multipart/form-data"
                  class="space-y-4" x-data="{ fileName: '' }">
                <?php echo csrf_field(); ?>
                <label class="flex flex-col items-center justify-center gap-3 rounded-2xl border-2 border-dashed border-borderColor/70 px-6 py-8 text-center cursor-pointer hover:border-primary/60 transition">
                    <div class="h-12 w-12 rounded-full bg-primary/10 text-primary flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 16V8m0 0-3 3m3-3 3 3M4 16v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-2"/>
                        </svg>
                    </div>
                    <div>
                        <p class="font-semibold text-textPrimary">Choose CSV/XLSX to import your product library</p>
                        <p class="text-xs text-textSecondary mt-1" x-text="fileName ? `Selected: ${fileName}` : 'Allowed formats: .csv, .xlsx (max 5MB)'"></p>
                    </div>
                    <input type="file" name="import_file" accept=".csv,.xlsx" class="hidden"
                           @change="fileName = $event.target.files[0]?.name || ''">
                </label>
                <div class="flex items-center justify-between flex-wrap gap-3">
                    <p class="text-xs text-textSecondary">Expected columns: name, selling_price, cost_price, is_active, color, storage, barcode, initial_stock, imei, serial_number, condition, network_status.</p>
                    <button type="submit"
                            class="px-4 py-2 rounded-2xl bg-primary text-white text-sm shadow shadow-primary/40 hover:bg-primary/90 transition">
                        Import File
                    </button>
                </div>
            </form>
            <?php $__errorArgs = ['import_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="text-sm text-red-500 mt-2"><?php echo e($message); ?></p>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="overflow-x-auto custom-scroll">
            <table class="w-full text-sm">
                <thead>
                    <tr class="text-left text-textSecondary/80 uppercase tracking-widest text-xs bg-white/60">
                        <th class="px-6 py-4">Product</th>
                        <th class="px-6 py-4">Selling Price</th>
                        <th class="px-6 py-4">Variations</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4 text-right">Actions</th>
                    </tr>
                </thead>

                <tbody class="bg-white/70">
                    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="border-t border-white/60 hover:bg-white/90 transition">
                            <td class="px-6 py-5">
                                <p class="font-semibold text-textPrimary"><?php echo e($product->name); ?></p>
                                <p class="text-xs text-textSecondary">ID: #<?php echo e($product->id); ?></p>
                                <p class="text-xs text-textSecondary mt-1">Category: <?php echo e($product->category_code ?? '—'); ?></p>
                            </td>
                            <td class="px-6 py-5 font-medium">$<?php echo e(number_format($product->selling_price, 2)); ?></td>
                            <td class="px-6 py-5 text-textSecondary">
                                <?php echo e($product->variations->count()); ?> variations
                            </td>
                            <td class="px-6 py-5">
                                <span class="badge-pill <?php echo e($product->is_active ? 'bg-emerald-50 text-emerald-600' : 'bg-red-50 text-red-600'); ?>">
                                    <?php echo e($product->is_active ? 'Active' : 'Inactive'); ?>

                                </span>
                            </td>
                            <td class="px-6 py-5 text-right">
                                <a href="<?php echo e(route('products.show', $product->id)); ?>"
                                   class="text-primary font-semibold hover:underline">View</a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="px-6 py-8 text-center text-textSecondary">
                                No products yet. Start by creating your first item.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="px-6 py-4 border-t border-white/60">
            <?php echo e($products->links()); ?>

        </div>
    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH D:\Work with client\New folder\phone_inventory_system 3\phone_inventory_system\resources\views/products/index.blade.php ENDPATH**/ ?>