<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Repairs']); ?>

    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-6">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Repairs</p>
            <h1 class="text-3xl font-semibold mt-2">Repair Tickets</h1>
            <p class="text-sm text-textSecondary mt-1">Monitor device repairs across branches</p>
        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('technical.create')): ?>
        <a href="<?php echo e(route('repairs.create')); ?>"
           class="px-5 py-3 rounded-2xl bg-primary text-white font-semibold shadow-sm text-sm">
            + New Repair
        </a>
        <?php endif; ?>
    </div>

    <div class="bg-white border border-borderColor rounded-3xl shadow-sm overflow-hidden">
        <div class="overflow-x-auto custom-scroll">
            <table class="w-full text-sm">
                <thead class="bg-bgLight text-textSecondary uppercase text-xs tracking-wide">
                    <tr>
                        <th class="px-6 py-3 text-left">Code</th>
                        <th class="px-6 py-3 text-left">Device</th>
                        <th class="px-6 py-3 text-left">Issue</th>
                        <th class="px-6 py-3 text-center">Status</th>
                        <th class="px-6 py-3 text-left">Created</th>
                        <th class="px-6 py-3 text-right">Actions</th>
                    </tr>
                </thead>

                <tbody class="bg-white">
                    <?php $__empty_1 = true; $__currentLoopData = $repairs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $repair): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="border-t border-borderColor/60 hover:bg-bgLight/60 transition">
                            <td class="px-6 py-4 font-semibold text-textPrimary"><?php echo e($repair->repair_code); ?></td>
                            <td class="px-6 py-4"><?php echo e($repair->device_model); ?></td>
                            <td class="px-6 py-4 text-textSecondary"><?php echo e(\Illuminate\Support\Str::limit($repair->issue, 40)); ?></td>
                            <td class="px-6 py-4 text-center">
                                <span class="px-3 py-1 rounded-full text-xs font-semibold
                                    <?php if($repair->status === 'completed'): ?> bg-emerald-50 text-emerald-600
                                    <?php elseif($repair->status === 'in_progress'): ?> bg-amber-50 text-amber-600
                                    <?php elseif($repair->status === 'delivered'): ?> bg-blue-50 text-blue-600
                                    <?php else: ?> bg-slate-100 text-slate-600 <?php endif; ?>">
                                    <?php echo e(ucwords(str_replace('_', ' ', $repair->status))); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4"><?php echo e($repair->created_at->format('M d, Y')); ?></td>
                            <td class="px-6 py-4 text-right space-x-3">
                                <a href="<?php echo e(route('repairs.show', $repair->id)); ?>" class="text-primary text-sm font-semibold">View</a>
                                <a href="<?php echo e(route('repairs.edit', $repair->id)); ?>" class="text-textSecondary text-sm">Edit</a>
                                <form action="<?php echo e(route('repairs.destroy', $repair->id)); ?>" method="POST" class="inline">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="text-red-500 text-sm" onclick="return confirm('Delete this repair?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="px-6 py-10 text-center text-textSecondary">No repairs yet.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="px-6 py-4 border-t border-borderColor/60">
            <?php echo e($repairs->links()); ?>

        </div>
    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH D:\Work with client\New folder\phone_inventory_system 3\phone_inventory_system\resources\views/repairs/index.blade.php ENDPATH**/ ?>