<x-app-layout title="Edit Role">

    <div class="flex items-center justify-between mb-8">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Settings</p>
            <h1 class="text-3xl font-semibold mt-2">Edit Role</h1>
            <p class="text-sm text-textSecondary">Update {{ $role->name }}</p>
        </div>
        <a href="{{ route('settings.roles.index') }}" class="text-primary text-sm hover:underline">← Back to roles</a>
    </div>

    <form action="{{ route('settings.roles.update', $role->id) }}" method="POST" class="bg-white border border-borderColor rounded-3xl shadow-sm p-8 space-y-6">
        @csrf
        @method('PUT')

        <div>
            <label class="text-sm font-medium text-textSecondary mb-2 block">Name</label>
            <input type="text" name="name" value="{{ old('name', $role->name) }}"
                   class="w-full rounded-2xl border border-borderColor px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                   required>
        </div>

        <div>
            <p class="text-sm font-medium text-textSecondary mb-2">Permissions</p>
            <div class="grid md:grid-cols-2 gap-2 max-h-72 overflow-y-auto custom-scroll">
                @foreach($permissions as $permission)
                    <label class="flex items-center gap-2 text-sm text-textSecondary border border-borderColor/60 rounded-2xl px-3 py-2">
                        <input type="checkbox" name="permissions[]" value="{{ $permission->name }}"
                               class="rounded border-borderColor text-primary focus:ring-primary/40"
                               {{ in_array($permission->name, $assigned) ? 'checked' : '' }}>
                        <span>{{ $permission->name }}</span>
                    </label>
                @endforeach
            </div>
        </div>

        @if ($errors->any())
            <div class="rounded-2xl bg-red-50 border border-red-200 text-sm text-red-600 px-4 py-3">
                <ul class="list-disc list-inside space-y-1">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="flex justify-end">
            <button type="submit"
                    class="px-6 py-3 rounded-2xl bg-primary text-white font-semibold shadow-sm">
                Update Role
            </button>
        </div>
    </form>

</x-app-layout>
