<x-app-layout title="New Sale">

    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Sales</p>
            <h1 class="text-3xl font-semibold mt-2">Create Invoice</h1>
            <p class="text-sm text-textSecondary mt-1">Record a customer sale and update stock</p>
        </div>
        <a href="{{ route('sales.index') }}" class="text-primary hover:underline text-sm">← Back to sales</a>
    </div>

    @php
        $priceMap = $variations->mapWithKeys(fn($variation) => [
            $variation->id => optional($variation->product)->selling_price ?? 0
        ])->toArray();

        $phoneMeta = $variations->mapWithKeys(fn($variation) => [
            $variation->id => [
                'product_code' => $variation->product->category_code ?? '—',
                'product_name' => $variation->product->name ?? '—',
                'serial_number' => $variation->serial_number ?? '—',
                'sku' => $variation->sku,
                'display' => '—',
                'cpu' => '—',
                'capacity' => $variation->storage ?? '—',
                'ram' => '—',
                'storage' => $variation->storage ?? '—',
                'color' => $variation->color ?? '—',
                'country_code' => '—',
                'selling_price' => optional($variation->product)->selling_price ?? 0,
                'cost' => optional($variation->product)->cost_price ?? 0,
            ],
        ])->toArray();

        $computerMeta = $computerProducts->mapWithKeys(fn($computer) => [
            $computer->id => [
                'product_code' => $computer->product_code,
                'product_name' => $computer->name,
                'serial_number' => $computer->serial_number,
                'display' => $computer->display,
                'cpu' => $computer->cpu,
                'capacity' => $computer->capacity,
                'ram' => $computer->ram,
                'storage' => $computer->storage,
                'color' => $computer->color,
                'country_code' => $computer->country_code,
                'status' => $computer->status,
                'cost' => $computer->cost,
                'tax' => $computer->tax,
                'total_cost' => $computer->total_cost,
                'stock_qty' => $computer->stock_qty,
            ],
        ])->toArray();

        $phoneSerialMap = $variations->mapWithKeys(function ($variation) {
            $serial = $variation->serial_number;
            if (! $serial) {
                return [];
            }
            return [
                $serial => [
                    'id' => $variation->id,
                ],
            ];
        })->toArray();

        $computerSerialMap = $computerProducts->mapWithKeys(function ($computer) {
            $serial = $computer->serial_number;
            if (! $serial) {
                return [];
            }
            return [
                $serial => [
                    'id' => $computer->id,
                ],
            ];
        })->toArray();
    @endphp

    @include('sales._datalists')

    <form action="{{ route('sales.store') }}" method="POST" class="mt-8 space-y-6"
          x-data="salesForm(
                @js($priceMap),
                @js($phoneMeta),
                @js($computerMeta),
                @js($phoneSerialMap),
                @js($computerSerialMap),
                @js(old('customer_id', '')),
                @js($saleNumber),
                @js(old('tax', 0)),
                @js(old('paid_time', now()->format('H:i'))),
                @js(old('discount', 0)),
                @js(old('payment_method', '')),
                @js(old('bank_amount')),
                @js(old('cash_amount'))
          )">
        @csrf

        <div class="bg-white border border-borderColor rounded-3xl p-6 space-y-4 shadow-sm">
            <h2 class="text-lg font-semibold text-textPrimary">Invoice Information</h2>
            <div class="grid md:grid-cols-3 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Sales No. (Auto)</label>
                    <input type="text" value="{{ $saleNumber }}"
                           class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary"
                           readonly>
                    <p class="text-xs text-textSecondary mt-1">Sale code generated from timestamp.</p>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Sale Date</label>
                    <input type="date" name="sale_date" value="{{ now()->toDateString() }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                </div>
                <div class="flex flex-col">
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Customer ID</label>
                    <div class="flex items-center gap-2">
                        <input type="number" name="customer_id" min="1" step="1"
                               x-model.number="customerId"
                               class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                               placeholder="YYMMDDHHMMSS">
                        <button type="button"
                                class="px-3 py-2 rounded-xl bg-slate-100 text-sm text-textSecondary hover:bg-slate-200"
                                @click="generateCustomerId">
                            Generate
                        </button>
                    </div>
                </div>
            </div>
            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Customer Phone</label>
                    <input type="text" name="customer_phone" value="{{ old('customer_phone') }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="+855 12 345 678">
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Other Notes</label>
                    <textarea name="other" rows="3"
                              class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                              placeholder="Any additional remarks">{{ old('other') }}</textarea>
                </div>
            </div>
            @if($variations->isEmpty())
                <p class="text-sm text-red-500">No product variations available. Add a variation first to create sales.</p>
            @endif
        </div>

        <div class="bg-white border border-borderColor rounded-3xl p-6 space-y-4 shadow-sm">
            <div class="flex items-center justify-between">
                <div>
                    <h2 class="text-lg font-semibold text-textPrimary">Line Items</h2>
                    <p class="text-sm text-textSecondary">Select SKU, quantity, and selling price</p>
                </div>
                <button type="button"
                        class="px-4 py-2 rounded-xl bg-primary text-white text-sm font-medium shadow-sm disabled:opacity-40"
                        @click="addItem" @disabled($variations->isEmpty())>
                    + Add Item
                </button>
            </div>

            <template x-for="(item, index) in items" :key="item.uid">
                <div class="rounded-2xl border border-borderColor/70 bg-white p-4 space-y-3 shadow-sm">
                    <div class="grid md:grid-cols-3 gap-4">
                        <div>
                            <label class="text-sm text-textSecondary font-medium mb-1 block">Product Type</label>
                            <select x-model="item.product_type"
                                    :name="`items[${index}][product_type]`"
                                    class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                    @change="handleTypeChange(item)">
                                <option value="phone">Phone</option>
                                <option value="computer">Computer</option>
                            </select>
                        </div>
                        <div x-show="item.product_type === 'phone'" class="md:col-span-2" x-cloak>
                            <label class="text-sm text-textSecondary font-medium mb-1 block">Serial Number</label>
                            <input type="text"
                                   list="phone-serials"
                                   x-model="item.serial_input"
                                   @change="handleSerialInput(item)"
                                   class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                   placeholder="Type or select serial number">
                            <input type="hidden" :name="`items[${index}][variation_id]`" :value="item.variation_id">
                        </div>
                        <div x-show="item.product_type === 'computer'" class="md:col-span-2" x-cloak>
                            <label class="text-sm text-textSecondary font-medium mb-1 block">Computer Product</label>
                            <input type="text"
                                   list="computer-serials"
                                   x-model="item.serial_input"
                                   @change="handleSerialInput(item)"
                                   class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                   placeholder="Type or select computer serial">
                            <input type="hidden" :name="`items[${index}][computer_product_id]`" :value="item.computer_product_id">
                        </div>
                        <button type="button" class="text-sm text-red-500 hover:underline md:col-span-1 md:text-right" @click="removeItem(index)" x-show="items.length > 1">
                            Remove
                        </button>
                    </div>

                    <div class="grid md:grid-cols-4 gap-4">
                        <div>
                            <label class="text-sm text-textSecondary font-medium mb-1 block">Quantity</label>
                            <input type="number" min="1"
                                   x-model.number="item.qty"
                                   :name="`items[${index}][qty]`"
                                   class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                   required>
                        </div>
                        <div>
                            <label class="text-sm text-textSecondary font-medium mb-1 block">Price</label>
                            <input type="number" min="0" step="0.01"
                                   x-model.number="item.price"
                                   :name="`items[${index}][price]`"
                                   class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                   required>
                        </div>
                        <div>
                            <label class="text-sm text-textSecondary font-medium mb-1 block">Cost (auto)</label>
                            <input type="number" min="0" step="0.01"
                                   :value="item.cost"
                                   readonly
                                   class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 bg-slate-50 text-textSecondary">
                        </div>
                        <div>
                            <label class="text-sm text-textSecondary font-medium mb-1 block">Line Total</label>
                            <p class="text-xl font-semibold px-4 py-3 bg-bgLight rounded-2xl border border-borderColor/40 text-textPrimary"
                               x-text="formatCurrency(item.qty * item.price)"></p>
                        </div>
                    </div>

                    <div class="grid md:grid-cols-2 gap-4">
                        <div>
                            <label class="text-sm text-textSecondary font-medium mb-1 block">Line Profit</label>
                            <p class="text-lg font-semibold px-4 py-3 bg-white rounded-2xl border border-borderColor/60"
                               :class="((item.price - item.cost) * item.qty) >= 0 ? 'text-emerald-700' : 'text-red-600'"
                               x-text="formatCurrency((item.price - item.cost) * item.qty)"></p>
                        </div>
                    </div>

                    <div class="rounded-2xl bg-bgLight/70 border border-borderColor/60 p-4 text-sm text-textSecondary" x-show="item.meta" x-cloak>
                        <p class="font-semibold text-textPrimary mb-2" x-text="item.meta?.product_name || '—'"></p>
                        <div class="grid md:grid-cols-2 gap-2">
                            <div>
                                <p class="text-xs uppercase tracking-[0.2em]">Product ID</p>
                                <p class="font-medium text-textPrimary" x-text="item.meta?.product_code || '—'"></p>
                            </div>
                            <div>
                                <p class="text-xs uppercase tracking-[0.2em]">Serial Number</p>
                                <p class="font-medium text-textPrimary" x-text="item.meta?.serial_number || '—'"></p>
                            </div>
                            <template x-if="item.product_type === 'computer'">
                                <div>
                                    <p class="text-xs uppercase tracking-[0.2em]">Display</p>
                                    <p class="font-medium text-textPrimary" x-text="item.meta?.display || '—'"></p>
                                </div>
                            </template>
                            <div>
                                <p class="text-xs uppercase tracking-[0.2em]">CPU</p>
                                <p class="font-medium text-textPrimary" x-text="item.meta?.cpu || '—'"></p>
                            </div>
                            <div>
                                <p class="text-xs uppercase tracking-[0.2em]">Capacity / RAM / Storage</p>
                                <p class="font-medium text-textPrimary" x-text="formatSpec(item.meta)"></p>
                            </div>
                            <div>
                                <p class="text-xs uppercase tracking-[0.2em]">Color</p>
                                <p class="font-medium text-textPrimary" x-text="item.meta?.color || '—'"></p>
                            </div>
                            <div>
                                <p class="text-xs uppercase tracking-[0.2em]">Country Code</p>
                                <p class="font-medium text-textPrimary" x-text="item.meta?.country_code || '—'"></p>
                            </div>
                            <div>
                                <p class="text-xs uppercase tracking-[0.2em]">Selling Price</p>
                                <p class="font-medium text-textPrimary" x-text="formatCurrency(item.price)"></p>
                            </div>
                            <div>
                                <p class="text-xs uppercase tracking-[0.2em]">Cost</p>
                                <p class="font-medium text-textPrimary" x-text="formatCurrency(item.cost)"></p>
                            </div>
                        </div>
                    </div>
                </div>
            </template>

            @if ($errors->any())
                <div class="rounded-2xl bg-red-50 border border-red-200 text-sm text-red-600 px-4 py-3">
                    <ul class="list-disc list-inside space-y-1">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>

        <div class="grid md:grid-cols-2 gap-6">
            <div class="bg-white border border-borderColor rounded-3xl p-6 space-y-4 shadow-sm">
                <h2 class="text-lg font-semibold text-textPrimary">Payment & Timing</h2>
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Payment Method</label>
                        <select name="payment_method"
                                x-model="paymentMethod"
                                class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                required>
                            <option value="">Select option</option>
                            @foreach($paymentMethods as $method)
                                <option value="{{ $method }}" {{ old('payment_method') === $method ? 'selected' : '' }}>
                                    {{ $method }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block flex items-center justify-between gap-2">
                            <span>Paid Time</span>
                            <button type="button"
                                    class="text-xs text-primary hover:underline"
                                    @click="setPaidTimeToNow">
                                Set to now
                            </button>
                        </label>
                        <input type="time" name="paid_time"
                               x-model="paidTime"
                               class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50">
                    </div>
                </div>
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Tax</label>
                        <input type="number" name="tax" min="0" step="0.01"
                               x-model.number="taxAmount"
                               class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                               placeholder="0.00">
                    </div>
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Discount</label>
                        <input type="number" name="discount" min="0" step="0.01"
                               x-model.number="discountAmount"
                               class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                               placeholder="0.00">
                    </div>
                </div>
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Profit (auto)</label>
                        <input type="text" readonly
                               :value="formatCurrency(profitTotal)"
                               :class="`w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 font-semibold ${profitTotal >= 0 ? 'text-emerald-700' : 'text-red-600'}`">
                        <input type="hidden" name="profit" :value="profitNonNegative.toFixed(2)">
                    </div>
                </div>
                <div x-show="paymentMethod === 'Bank + Cash'" x-cloak class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Bank Portion</label>
                        <input type="number" name="bank_amount" min="0" step="0.01"
                               x-model.number="bankAmountInput"
                               :required="paymentMethod === 'Bank + Cash'"
                               class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                               placeholder="0.00">
                    </div>
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Cash Portion</label>
                        <input type="number" name="cash_amount" min="0" step="0.01"
                               x-model.number="cashAmountInput"
                               :required="paymentMethod === 'Bank + Cash'"
                               class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                               placeholder="0.00">
                    </div>
                    <div class="md:col-span-2">
                        <p class="text-xs"
                           :class="splitMatchesGrandTotal ? 'text-emerald-600' : 'text-red-600'">
                            Split total <span class="font-semibold" x-text="formatCurrency(splitTotal)"></span>
                            vs invoice total <span class="font-semibold" x-text="formatCurrency(grandTotal)"></span>
                        </p>
                    </div>
                </div>
            </div>

            <div class="bg-white border border-borderColor rounded-3xl p-6 space-y-4 shadow-sm">
                <h2 class="text-lg font-semibold text-textPrimary">Summary</h2>
                <div class="flex items-center justify-between">
                    <span class="text-textSecondary">Line Items</span>
                    <span class="font-semibold" x-text="items.length"></span>
                </div>
                <div class="space-y-2 text-sm text-textSecondary">
                    <div class="flex items-center justify-between">
                        <span>Subtotal</span>
                        <span class="font-semibold text-textPrimary" x-text="formatCurrency(totalAmount)"></span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span>Tax</span>
                        <span class="font-semibold text-textPrimary" x-text="formatCurrency(taxAmount || 0)"></span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span>Discount</span>
                        <span class="font-semibold text-textPrimary" x-text="'- ' + formatCurrency(discountAmount || 0)"></span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span>Profit</span>
                        <span class="font-semibold"
                              :class="profitTotal >= 0 ? 'text-emerald-700' : 'text-red-600'"
                              x-text="formatCurrency(profitTotal)"></span>
                    </div>
                </div>
                <div>
                    <p class="text-sm text-textSecondary">Invoice Total</p>
                    <p class="text-3xl font-semibold text-textPrimary" x-text="formatCurrency(grandTotal)"></p>
                </div>
            </div>
        </div>

        <div class="flex justify-end">
            <button type="submit"
                    class="px-8 py-3 rounded-2xl bg-primary text-white shadow-md font-semibold">
                Save Invoice
            </button>
        </div>
    </form>

    @push('scripts')
        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.data('salesForm', (priceMap = {}, phoneMeta = {}, computerMeta = {}, phoneSerialMap = {}, computerSerialMap = {}, initialCustomerId = '', saleNumber = '', initialTax = 0, initialPaidTime = '', initialDiscount = 0, initialPaymentMethod = '', initialBankAmount = null, initialCashAmount = null) => ({
                    priceMap,
                    phoneMeta,
                    computerMeta,
                    phoneSerialMap,
                    computerSerialMap,
                    customerId: initialCustomerId ?? '',
                    saleNumber,
                    taxAmount: Number(initialTax) || 0,
                    paidTime: initialPaidTime || '',
                    discountAmount: Number(initialDiscount) || 0,
                    paymentMethod: initialPaymentMethod || '',
                    bankAmountInput: initialBankAmount ?? '',
                    cashAmountInput: initialCashAmount ?? '',
                    items: [],
                    init() {
                        this.items = [this.newItem()];
                    },
                    newItem() {
                        return {
                            uid: (Date.now().toString(36) + Math.random().toString(36).slice(2, 7)),
                            product_type: 'phone',
                            variation_id: '',
                            computer_product_id: '',
                            serial_input: '',
                            qty: 1,
                            price: 0,
                            cost: 0,
                            meta: null,
                        };
                    },
                    addItem() {
                        this.items.push(this.newItem());
                    },
                    removeItem(index) {
                        if (this.items.length === 1) return;
                        this.items.splice(index, 1);
                    },
                    generateCustomerId() {
                        const now = new Date();
                        const pad = (v) => String(v).padStart(2, '0');
                        const stamp = `${now.getFullYear().toString().slice(-2)}${pad(now.getMonth() + 1)}${pad(now.getDate())}${pad(now.getHours())}${pad(now.getMinutes())}${pad(now.getSeconds())}`;
                        this.customerId = Number(stamp);
                    },
                    handleTypeChange(item) {
                        item.variation_id = '';
                        item.computer_product_id = '';
                        item.serial_input = '';
                        item.meta = null;
                        item.price = 0;
                        item.cost = 0;
                    },
                    setPhoneDetails(item) {
                        const meta = this.phoneMeta[item.variation_id];
                        if (meta) {
                            item.meta = meta;
                            item.price = Number(meta.selling_price) || 0;
                            item.cost = Number(meta.cost) || 0;
                        }
                    },
                    setComputerDetails(item) {
                        const meta = this.computerMeta[item.computer_product_id];
                        if (meta) {
                            item.meta = meta;
                            item.price = Number(meta.cost) + Number(meta.tax || 0);
                            item.cost = Number(meta.total_cost ?? (Number(meta.cost) + Number(meta.tax || 0))) || 0;
                        }
                    },
                    handleSerialInput(item) {
                        if (item.product_type === 'phone') {
                            const record = this.phoneSerialMap[item.serial_input];
                            item.variation_id = record ? record.id : '';
                            if (item.variation_id) {
                                this.setPhoneDetails(item);
                            } else {
                                item.meta = null;
                            }
                        } else {
                            const record = this.computerSerialMap[item.serial_input];
                            item.computer_product_id = record ? record.id : '';
                            if (item.computer_product_id) {
                                this.setComputerDetails(item);
                            } else {
                                item.meta = null;
                            }
                        }
                    },
                    formatCurrency(value) {
                        const number = Number(value) || 0;
                        return new Intl.NumberFormat('en-US', {
                            style: 'currency',
                            currency: 'USD'
                        }).format(number);
                    },
                    formatSpec(meta) {
                        if (!meta) {
                            return '—';
                        }
                        return [meta.capacity, meta.ram, meta.storage].filter(Boolean).join(' / ') || '—';
                    },
                    get totalAmount() {
                        return this.items.reduce((total, item) => {
                            return total + ((Number(item.qty) || 0) * (Number(item.price) || 0));
                        }, 0);
                    },
                    get profitTotal() {
                        return this.items.reduce((total, item) => {
                            const price = Number(item.price) || 0;
                            const cost = Number(item.cost) || 0;
                            return total + ((price - cost) * (Number(item.qty) || 0));
                        }, 0);
                    },
                    get profitNonNegative() {
                        return Math.max(0, this.profitTotal);
                    },
                    get grandTotal() {
                        return Math.max(0,
                            this.totalAmount +
                            (Number(this.taxAmount) || 0) -
                            (Number(this.discountAmount) || 0)
                        );
                    },
                    get splitTotal() {
                        return (Number(this.bankAmountInput) || 0) + (Number(this.cashAmountInput) || 0);
                    },
                    get splitMatchesGrandTotal() {
                        return Math.abs(this.splitTotal - this.grandTotal) < 0.01;
                    },
                    setPaidTimeToNow() {
                        const now = new Date();
                        const pad = (value) => String(value).padStart(2, '0');
                        this.paidTime = `${pad(now.getHours())}:${pad(now.getMinutes())}`;
                    }
                }));
            });
        </script>
    @endpush

</x-app-layout>
