<x-app-layout title="Edit Repair">

    <div class="flex items-center justify-between">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Repairs</p>
            <h1 class="text-3xl font-semibold mt-2">Edit Repair</h1>
            <p class="text-sm text-textSecondary mt-1">Update ticket {{ $repair->repair_code }}</p>
        </div>
        <a href="{{ route('repairs.show', $repair->id) }}" class="text-primary hover:underline text-sm">← Back to detail</a>
    </div>

    <form action="{{ route('repairs.update', $repair->id) }}" method="POST" class="bg-white border border-borderColor rounded-3xl shadow-sm p-8 mt-8 space-y-6"
          x-data="repairForm('{{ old('customer_id', $repair->customer_id) }}')">
        @csrf
        @method('PUT')

        <div class="grid md:grid-cols-2 gap-6">
            <div>
                <label class="block text-sm font-medium text-textSecondary mb-2">Customer ID</label>
                <div class="flex gap-2">
                    <input type="number" name="customer_id" min="1" x-model="customerId"
                           class="w-full rounded-2xl border border-borderColor px-4 py-3 focus:ring-primary/40 focus:border-primary/50">
                    <button type="button"
                            class="px-4 py-3 rounded-2xl bg-slate-100 text-sm text-textSecondary"
                            @click="generateId">
                        Generate
                    </button>
                </div>
            </div>

            <div>
                <label class="block text-sm font-medium text-textSecondary mb-2">Device Model</label>
                <input type="text" name="device_model" value="{{ old('device_model', $repair->device_model) }}"
                       class="w-full rounded-2xl border border-borderColor px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                       required>
            </div>
        </div>

        @php
            $oldIssues = old('issues', $selectedIssues ?? []);
            $oldCustom = old('issue_custom', $customIssuePrefill ?? '');
        @endphp

        <div class="space-y-4">
            <label class="block text-sm font-medium text-textSecondary">Issue Description</label>
            <p class="text-xs text-textSecondary">Update the issue list or add more notes.</p>
            <div class="space-y-4 max-h-[420px] overflow-y-auto pr-2 custom-scroll">
                @foreach($issueOptions as $group => $issues)
                    <div>
                        <p class="text-sm font-semibold text-textPrimary">{{ $group }}</p>
                        <div class="grid md:grid-cols-2 gap-2 mt-2">
                            @foreach($issues as $issue)
                                <label class="flex items-start gap-2 text-sm text-textSecondary">
                                    <input type="checkbox" name="issues[]" value="{{ $issue }}"
                                           class="mt-1 rounded border-borderColor text-primary focus:ring-primary/40"
                                           {{ in_array($issue, $oldIssues) ? 'checked' : '' }}>
                                    <span>{{ $issue }}</span>
                                </label>
                            @endforeach
                        </div>
                    </div>
                @endforeach
            </div>

            <textarea name="issue_custom" rows="3"
                      class="w-full rounded-2xl border border-borderColor px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                      placeholder="Additional notes">{{ $oldCustom }}</textarea>
        </div>

        <div>
            <label class="block text-sm font-medium text-textSecondary mb-2">Status</label>
            <select name="status"
                    class="w-full rounded-2xl border border-borderColor px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                @foreach($statuses as $status)
                    <option value="{{ $status }}" {{ old('status', $repair->status) === $status ? 'selected' : '' }}>
                        {{ ucwords(str_replace('_', ' ', $status)) }}
                    </option>
                @endforeach
            </select>
        </div>

        @if ($errors->any())
            <div class="rounded-2xl bg-red-50 border border-red-200 text-sm text-red-600 px-4 py-3">
                <ul class="list-disc list-inside space-y-1">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="flex justify-end">
            <button type="submit"
                    class="px-6 py-3 rounded-2xl bg-primary text-white font-semibold shadow-sm">
                Update Repair
            </button>
        </div>
    </form>

    @push('scripts')
        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.data('repairForm', (initialId = '') => ({
                    customerId: initialId || '',
                    generateId() {
                        this.customerId = Math.floor(Date.now() / 1000);
                    }
                }));
            });
        </script>
    @endpush

</x-app-layout>
