<x-app-layout title="Products">

    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Catalog</p>
            <h1 class="text-3xl font-semibold mt-2">Product Library</h1>
            <p class="text-sm text-textSecondary mt-1">Manage sellable devices and their variations</p>
        </div>
        @can('products.create')
        <a href="{{ route('products.create') }}"
           class="inline-flex items-center gap-2 px-5 py-3 rounded-2xl bg-gradient-to-r from-primary to-primaryDark text-white shadow-lg shadow-primary/40 transition hover:translate-y-0.5">
            <span>＋</span>
            New Product
        </a>
        @endcan
    </div>

    <div class="glass-card rounded-3xl p-0 overflow-hidden mt-8">
        @if (session('success'))
            <div class="px-6 py-4 border-b border-white/60 bg-emerald-50 text-emerald-700 text-sm">
                {{ session('success') }}
            </div>
        @endif

        <div class="px-6 py-5 border-b border-white/60 bg-white/80">
            <form action="{{ route('products.import') }}" method="POST" enctype="multipart/form-data"
                  class="space-y-4" x-data="{ fileName: '' }">
                @csrf
                <label class="flex flex-col items-center justify-center gap-3 rounded-2xl border-2 border-dashed border-borderColor/70 px-6 py-8 text-center cursor-pointer hover:border-primary/60 transition">
                    <div class="h-12 w-12 rounded-full bg-primary/10 text-primary flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 16V8m0 0-3 3m3-3 3 3M4 16v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-2"/>
                        </svg>
                    </div>
                    <div>
                        <p class="font-semibold text-textPrimary">Choose CSV/XLSX to import your product library</p>
                        <p class="text-xs text-textSecondary mt-1" x-text="fileName ? `Selected: ${fileName}` : 'Allowed formats: .csv, .xlsx (max 5MB)'"></p>
                    </div>
                    <input type="file" name="import_file" accept=".csv,.xlsx" class="hidden"
                           @change="fileName = $event.target.files[0]?.name || ''">
                </label>
                <div class="flex items-center justify-between flex-wrap gap-3">
                    <p class="text-xs text-textSecondary">Expected columns: name, selling_price, cost_price, is_active, color, storage, barcode, initial_stock, imei, serial_number, condition, network_status.</p>
                    <button type="submit"
                            class="px-4 py-2 rounded-2xl bg-primary text-white text-sm shadow shadow-primary/40 hover:bg-primary/90 transition">
                        Import File
                    </button>
                </div>
            </form>
            @error('import_file')
                <p class="text-sm text-red-500 mt-2">{{ $message }}</p>
            @enderror
        </div>

        <div class="overflow-x-auto custom-scroll">
            <table class="w-full text-sm">
                <thead>
                    <tr class="text-left text-textSecondary/80 uppercase tracking-widest text-xs bg-white/60">
                        <th class="px-6 py-4">Product</th>
                        <th class="px-6 py-4">Selling Price</th>
                        <th class="px-6 py-4">Variations</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4 text-right">Actions</th>
                    </tr>
                </thead>

                <tbody class="bg-white/70">
                    @forelse ($products as $product)
                        <tr class="border-t border-white/60 hover:bg-white/90 transition">
                            <td class="px-6 py-5">
                                <p class="font-semibold text-textPrimary">{{ $product->name }}</p>
                                <p class="text-xs text-textSecondary">ID: #{{ $product->id }}</p>
                                <p class="text-xs text-textSecondary mt-1">Category: {{ $product->category_code ?? '—' }}</p>
                            </td>
                            <td class="px-6 py-5 font-medium">${{ number_format($product->selling_price, 2) }}</td>
                            <td class="px-6 py-5 text-textSecondary">
                                {{ $product->variations->count() }} variations
                            </td>
                            <td class="px-6 py-5">
                                <span class="badge-pill {{ $product->is_active ? 'bg-emerald-50 text-emerald-600' : 'bg-red-50 text-red-600' }}">
                                    {{ $product->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </td>
                            <td class="px-6 py-5 text-right">
                                <a href="{{ route('products.show', $product->id) }}"
                                   class="text-primary font-semibold hover:underline">View</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-8 text-center text-textSecondary">
                                No products yet. Start by creating your first item.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="px-6 py-4 border-t border-white/60">
            {{ $products->links() }}
        </div>
    </div>

</x-app-layout>
