<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $title ?? 'Dashboard' }}</title>

    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="relative text-textPrimary min-h-screen">

    {{-- Background accents --}}
    <div class="pointer-events-none absolute inset-0 overflow-hidden">
        <div class="absolute -right-16 top-10 w-64 h-64 bg-primary/10 blur-3xl rounded-full animate-soft-bounce"></div>
        <div class="absolute left-12 bottom-0 w-72 h-72 bg-primaryLight/20 blur-3xl rounded-full animate-soft-bounce" style="animation-delay: .8s;"></div>
    </div>

    <div class="relative flex min-h-screen">
        {{-- SIDEBAR --}}
        @include('components.sidebar')

        <div class="flex-1 flex flex-col min-h-screen ml-64">
            {{-- TOPBAR --}}
            @include('components.topbar')

            {{-- PAGE CONTENT --}}
            <main class="flex-1 px-8 pb-10 pt-6">
                <div class="animate-fade-up space-y-6">
                    {{ $slot }}
                </div>
            </main>
        </div>
    </div>

    @stack('scripts')
</body>
</html>
