<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sale_items', function (Blueprint $table) {
            if (! Schema::hasColumn('sale_items', 'product_type')) {
                $table->string('product_type')->default('phone')->after('sale_id');
            }

            if (! Schema::hasColumn('sale_items', 'computer_product_id')) {
                $table->foreignId('computer_product_id')->nullable()->after('variation_id')->constrained('computer_products')->nullOnDelete();
            }

            if (! Schema::hasColumn('sale_items', 'serial_number')) {
                $table->string('serial_number')->nullable()->after('computer_product_id');
            }

            $table->unsignedBigInteger('variation_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sale_items', function (Blueprint $table) {
            if (Schema::hasColumn('sale_items', 'computer_product_id')) {
                $table->dropConstrainedForeignId('computer_product_id');
            }

            if (Schema::hasColumn('sale_items', 'product_type')) {
                $table->dropColumn('product_type');
            }

            if (Schema::hasColumn('sale_items', 'serial_number')) {
                $table->dropColumn('serial_number');
            }

            $table->unsignedBigInteger('variation_id')->nullable(false)->change();
        });
    }
};
