<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('purchases', function (Blueprint $table) {
            if (! Schema::hasColumn('purchases', 'purchase_code')) {
                $table->string('purchase_code')->nullable()->unique()->after('po_number');
            }

            if (! Schema::hasColumn('purchases', 'invoice_number')) {
                $table->string('invoice_number')->nullable()->after('purchase_code');
            }

            if (! Schema::hasColumn('purchases', 's_invoice_number')) {
                $table->string('s_invoice_number')->nullable()->unique()->after('invoice_number');
            }

            if (! Schema::hasColumn('purchases', 'tax_amount')) {
                $table->decimal('tax_amount', 12, 2)->default(0)->after('total_amount');
            }

            if (! Schema::hasColumn('purchases', 'other_charges')) {
                $table->decimal('other_charges', 12, 2)->default(0)->after('tax_amount');
            }

            if (! Schema::hasColumn('purchases', 'total_due')) {
                $table->decimal('total_due', 12, 2)->default(0)->after('other_charges');
            }
        });

        Schema::table('purchase_items', function (Blueprint $table) {
            if (! Schema::hasColumn('purchase_items', 'serial_number')) {
                $table->string('serial_number')->nullable()->after('variation_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('purchases', function (Blueprint $table) {
            $columns = collect([
                'purchase_code',
                'invoice_number',
                's_invoice_number',
                'tax_amount',
                'other_charges',
                'total_due',
            ])->filter(fn ($column) => Schema::hasColumn('purchases', $column))->toArray();

            if (! empty($columns)) {
                $table->dropColumn($columns);
            }
        });

        Schema::table('purchase_items', function (Blueprint $table) {
            if (Schema::hasColumn('purchase_items', 'serial_number')) {
                $table->dropColumn('serial_number');
            }
        });
    }
};
