<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            if (!Schema::hasColumn('products', 'category_code')) {
                $table->string('category_code')->nullable()->after('name');
            }
        });

        Schema::table('product_variations', function (Blueprint $table) {
            if (!Schema::hasColumn('product_variations', 'imei')) {
                $table->string('imei')->nullable()->unique()->after('sku');
            }

            if (!Schema::hasColumn('product_variations', 'serial_number')) {
                $table->string('serial_number')->nullable()->unique()->after('imei');
            }

            if (!Schema::hasColumn('product_variations', 'condition')) {
                $table->string('condition')->default('New')->after('serial_number');
            }

            if (!Schema::hasColumn('product_variations', 'network_status')) {
                $table->string('network_status')->nullable()->after('condition');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            if (Schema::hasColumn('products', 'category_code')) {
                $table->dropColumn('category_code');
            }
        });

        Schema::table('product_variations', function (Blueprint $table) {
            $columns = collect(['imei', 'serial_number', 'condition', 'network_status'])
                ->filter(fn ($column) => Schema::hasColumn('product_variations', $column))
                ->toArray();

            if (! empty($columns)) {
                $table->dropColumn($columns);
            }
        });
    }
};
