<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
{
    Schema::create('purchase_items', function (Blueprint $table) {
        $table->id();
        $table->unsignedBigInteger('purchase_id');
        $table->unsignedBigInteger('variation_id');
        $table->integer('qty');
        $table->decimal('cost_price', 10, 2);
        $table->timestamps();

        $table->foreign('purchase_id')->references('id')->on('purchases')->onDelete('cascade');
        $table->foreign('variation_id')->references('id')->on('product_variations');
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_items');
    }
};
