<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
{
    Schema::create('purchases', function (Blueprint $table) {
        $table->id();
        $table->string('po_number')->unique();
        $table->unsignedBigInteger('supplier_id');
        $table->date('purchase_date');
        $table->decimal('total_amount', 12, 2);
        $table->enum('status', ['pending', 'received', 'partial', 'cancelled'])->default('pending');
        $table->timestamps();

        $table->foreign('supplier_id')->references('id')->on('suppliers');
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchases');
    }
};
