<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductVariation extends Model
{
    protected $fillable = [
        'product_id',
        'color',
        'storage',
        'sku',
        'barcode',
        'imei',
        'serial_number',
        'condition',
        'network_status'
    ];

    public static function nextSku(): string
    {
        $latestSku = static::whereNotNull('sku')->orderByDesc('id')->value('sku');

        if ($latestSku && preg_match('/SKU(\d+)/', $latestSku, $matches)) {
            $nextNumber = (int) $matches[1] + 1;
        } else {
            $nextNumber = 1;
        }

        return 'SKU' . str_pad((string) $nextNumber, 3, '0', STR_PAD_LEFT);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function stockMovements()
    {
        return $this->hasMany(StockMovement::class, 'variation_id');
    }
}
