<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\ProductController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\SalesController;
use App\Http\Controllers\RepairController;
use App\Http\Controllers\StockController;

// -------------------------------
// API AUTH (optional: sanctum)
// -------------------------------
Route::middleware('auth:sanctum')->group(function () {

    // Inventory List (Mobile App)
    Route::get('/stock', [StockController::class, 'index']);

    // Products
    Route::get('/products', [ProductController::class, 'index']);
    Route::get('/products/{id}', [ProductController::class, 'show']);

    // Sales
    Route::post('/sales', [SalesController::class, 'store']);

    // Purchases
    Route::post('/purchases', [PurchaseController::class, 'store']);
    Route::post('/purchases/{id}/receive', [PurchaseController::class, 'receive']);

    // Repairs
    Route::post('/repairs', [RepairController::class, 'store']);
    Route::post('/repairs/{id}/status', [RepairController::class, 'updateStatus']);
});
