<x-app-layout title="Suppliers">

    <h1 class="text-xl font-semibold mb-6">Suppliers</h1>

    @if (session('status'))
        <div class="mb-4 rounded-xl border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-700">
            {{ session('status') }}
        </div>
    @endif

    @if ($errors->any())
        <div class="mb-4 rounded-xl border border-red-200 bg-red-50 px-4 py-3 text-sm text-red-700">
            <ul class="list-disc list-inside">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @can('suppliers.create')
    <div class="bg-white p-6 rounded-xl shadow border mb-6">
        <form action="{{ route('suppliers.store') }}" method="POST" class="grid grid-cols-4 gap-4">
            @csrf

            <input name="name" type="text" placeholder="Supplier Name"
                   class="border px-3 py-2 rounded-lg col-span-2">

            <input name="phone" type="text" placeholder="Phone"
                   class="border px-3 py-2 rounded-lg">

            <input name="email" type="text" placeholder="Email"
                   class="border px-3 py-2 rounded-lg">

            <input name="address" type="text" placeholder="Address"
                   class="border px-3 py-2 rounded-lg col-span-4">

            <button class="bg-primary text-white px-4 py-2 rounded-lg col-span-1">
                Add Supplier
            </button>
        </form>
    </div>

    <div class="bg-white p-6 rounded-xl shadow border mb-6">
        <h2 class="text-lg font-semibold mb-4">Import Suppliers</h2>
        <form action="{{ route('suppliers.import') }}" method="POST" enctype="multipart/form-data"
              class="space-y-4" x-data="{ fileName: '' }">
            @csrf
            <label class="flex flex-col items-center justify-center gap-3 rounded-2xl border-2 border-dashed border-borderColor/70 px-6 py-8 text-center cursor-pointer hover:border-primary/60 transition">
                <div class="h-12 w-12 rounded-full bg-primary/10 text-primary flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 16V8m0 0-3 3m3-3 3 3M4 16v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-2"/>
                    </svg>
                </div>
                <div>
                    <p class="font-semibold text-textPrimary">Drop your CSV/XLSX here or click to browse</p>
                    <p class="text-sm text-textSecondary mt-1" x-text="fileName ? `Selected: ${fileName}` : 'Allowed formats: .csv, .txt, .xlsx (max 5MB)'"></p>
                </div>
                <input type="file" name="file" accept=".csv,.txt,.xlsx"
                       class="hidden" @change="fileName = $event.target.files[0]?.name || ''">
            </label>
            <div class="flex items-center justify-between flex-wrap gap-3">
                <p class="text-sm text-textSecondary">File must include columns: <span class="font-semibold text-textPrimary">name, phone, email, address</span>. First row is treated as the header.</p>
                <button class="bg-primary text-white px-5 py-2.5 rounded-xl shadow-sm hover:bg-primary/90 transition">
                    Import File
                </button>
            </div>
        </form>
    </div>
    @endcan

    <div class="bg-white p-6 rounded-xl shadow border">

        <table class="w-full text-sm">
            <thead>
                <tr class="border-b text-textSecondary">
                    <th class="py-2">Name</th>
                    <th class="py-2">Phone</th>
                    <th class="py-2">Email</th>
                    <th class="py-2">Address</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($suppliers as $s)
                    <tr class="border-b">
                        <td class="py-3">{{ $s->name }}</td>
                        <td>{{ $s->phone }}</td>
                        <td>{{ $s->email }}</td>
                        <td>{{ $s->address }}</td>
                    </tr>
                @endforeach
            </tbody>

        </table>

        <div class="mt-4">
            {{ $suppliers->links() }}
        </div>

    </div>

</x-app-layout>
