<x-app-layout title="Manage Users">

    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-8">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Settings</p>
            <h1 class="text-3xl font-semibold mt-2">Users</h1>
            <p class="text-sm text-textSecondary">Create accounts and assign roles</p>
        </div>
        <a href="{{ route('settings.index') }}" class="text-primary text-sm hover:underline">← Back to settings</a>
    </div>

    <div class="grid gap-6 lg:grid-cols-2">
        @can('settings.update')
        <div class="bg-white border border-borderColor rounded-3xl shadow-sm p-6 space-y-4">
            <h2 class="text-lg font-semibold text-textPrimary">Add User</h2>
            <form action="{{ route('settings.users.store') }}" method="POST" class="space-y-4">
                @csrf
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1">Name</label>
                        <input type="text" name="name" value="{{ old('name') }}" class="w-full rounded-2xl border border-borderColor px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                    </div>
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1">Email</label>
                        <input type="email" name="email" value="{{ old('email') }}" class="w-full rounded-2xl border border-borderColor px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                    </div>
                </div>

                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1">Password</label>
                        <input type="password" name="password" class="w-full rounded-2xl border border-borderColor px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                    </div>
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1">Branch</label>
                        <select name="branch_id" class="w-full rounded-2xl border border-borderColor px-4 py-3 focus:ring-primary/40 focus:border-primary/50">
                            <option value="">Select branch</option>
                            @foreach($branches as $branch)
                                <option value="{{ $branch->id }}">{{ $branch->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div>
                    <p class="text-sm text-textSecondary font-medium mb-1">Roles</p>
                    <div class="grid md:grid-cols-2 gap-2">
                        @foreach($roles as $role)
                            <label class="flex items-center gap-2 text-sm text-textSecondary border border-borderColor/60 rounded-2xl px-3 py-2">
                                <input type="checkbox" name="roles[]" value="{{ $role->name }}" class="rounded border-borderColor text-primary focus:ring-primary/40">
                                <span>{{ $role->name }}</span>
                            </label>
                        @endforeach
                    </div>
                </div>

                @if ($errors->any())
                    <div class="rounded-2xl bg-red-50 border border-red-200 text-sm text-red-600 px-4 py-3">
                        <ul class="list-disc list-inside space-y-1">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <button type="submit" class="px-6 py-3 rounded-2xl bg-primary text-white font-semibold shadow-sm">Create User</button>
            </form>
        </div>
        @endcan

        <div class="bg-white border border-borderColor rounded-3xl shadow-sm p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-lg font-semibold text-textPrimary">Existing Users</h2>
                <span class="badge-pill bg-slate-100 text-textSecondary text-xs">{{ $users->count() }} total</span>
            </div>
            <div class="space-y-4 max-h-[540px] overflow-y-auto custom-scroll">
                @forelse($users as $user)
                    <div class="border border-borderColor/60 rounded-2xl px-4 py-3 text-sm">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="font-semibold text-textPrimary">{{ $user->name }}</p>
                                <p class="text-xs text-textSecondary">{{ $user->email }}</p>
                            </div>
                            <span class="text-xs text-textSecondary">{{ $user->branch->name ?? 'No branch' }}</span>
                        </div>
                        @can('settings.update')
                        <form action="{{ route('settings.users.roles.update', $user) }}" method="POST" class="mt-3">
                            @csrf
                            @method('PATCH')
                            <div class="grid md:grid-cols-2 gap-2">
                                @foreach($roles as $role)
                                    <label class="flex items-center gap-2 text-xs text-textSecondary border border-borderColor/60 rounded-2xl px-3 py-2">
                                        <input type="checkbox" name="roles[]" value="{{ $role->name }}"
                                               class="rounded border-borderColor text-primary focus:ring-primary/40"
                                               {{ $user->roles->contains('name', $role->name) ? 'checked' : '' }}>
                                        <span>{{ $role->name }}</span>
                                    </label>
                                @endforeach
                            </div>
                            <div class="mt-3 text-right">
                                <button type="submit" class="px-4 py-2 rounded-2xl bg-bgLight text-textPrimary text-xs font-semibold">Save Roles</button>
                            </div>
                        </form>
                        @endcan
                    </div>
                @empty
                    <p class="text-sm text-textSecondary">No users found.</p>
                @endforelse
            </div>
        </div>
    </div>

</x-app-layout>
