<x-app-layout title="Settings">

    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-8">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Settings</p>
            <h1 class="text-3xl font-semibold mt-2">Access & Presence</h1>
            <p class="text-sm text-textSecondary">Manage roles, permissions, and monitor user activity</p>
        </div>
        <div class="flex items-center gap-2">
            <a href="{{ route('settings.users.index') }}" class="px-4 py-2 rounded-2xl bg-bgLight text-textPrimary text-sm font-semibold shadow-sm">
                Manage Users
            </a>
            <a href="{{ route('settings.roles.index') }}" class="px-4 py-2 rounded-2xl bg-primary text-white text-sm font-semibold shadow-sm">
                Manage Roles
            </a>
        </div>
    </div>

    <div class="grid gap-6 lg:grid-cols-2">
        <div class="bg-white border border-borderColor rounded-3xl shadow-sm p-6 space-y-4">
            <div class="flex items-center justify-between">
                <h2 class="text-lg font-semibold text-textPrimary">Roles</h2>
                <span class="badge-pill bg-primary/10 text-primary text-xs">{{ $roles->count() }} total</span>
            </div>
            <div class="space-y-3">
                @forelse($roles as $role)
                    <div class="flex items-center justify-between text-sm bg-bgLight/60 rounded-2xl px-4 py-3">
                        <div>
                            <p class="font-semibold text-textPrimary">{{ $role->name }}</p>
                            <p class="text-xs text-textSecondary">Users: {{ $role->users_count }}</p>
                        </div>
                        <span class="text-textSecondary text-xs uppercase tracking-wide">{{ $role->guard_name }}</span>
                    </div>
                @empty
                    <p class="text-sm text-textSecondary">No roles defined.</p>
                @endforelse
            </div>
        </div>

        <div class="bg-white border border-borderColor rounded-3xl shadow-sm p-6 space-y-4">
            <div class="flex items-center justify-between">
                <h2 class="text-lg font-semibold text-textPrimary">Permissions</h2>
                <span class="badge-pill bg-slate-100 text-textSecondary text-xs">{{ $permissions->count() }} total</span>
            </div>
            <div class="space-y-3 max-h-72 overflow-y-auto custom-scroll">
                @forelse($permissions as $permission)
                    <div class="flex items-center justify-between text-sm border border-borderColor/60 rounded-2xl px-4 py-3">
                        <span class="text-textPrimary">{{ $permission->name }}</span>
                        <span class="text-xs text-textSecondary">Roles: {{ $permission->roles_count }}</span>
                    </div>
                @empty
                    <p class="text-sm text-textSecondary">No permissions configured.</p>
                @endforelse
            </div>
        </div>
    </div>

    <div class="mt-8 bg-white border border-borderColor rounded-3xl shadow-sm">
        <div class="p-6 border-b border-borderColor/60 flex items-center justify-between">
            <h2 class="text-lg font-semibold text-textPrimary">Users Online</h2>
            <span class="badge-pill bg-emerald-50 text-emerald-600 text-xs">
                {{ $users->where('is_online')->count() }} online
            </span>
        </div>
        <div class="overflow-x-auto custom-scroll">
            <table class="w-full text-sm">
                <thead class="bg-bgLight text-textSecondary uppercase text-xs tracking-wide">
                    <tr>
                        <th class="px-6 py-3 text-left">User</th>
                        <th class="px-6 py-3 text-left">Branch</th>
                        <th class="px-6 py-3 text-left">Roles</th>
                        <th class="px-6 py-3 text-center">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white">
                    @forelse($users as $user)
                        <tr class="border-t border-borderColor/60">
                            <td class="px-6 py-4">
                                <p class="font-semibold text-textPrimary">{{ $user->name }}</p>
                                <p class="text-xs text-textSecondary">{{ $user->email }}</p>
                            </td>
                            <td class="px-6 py-4">{{ $user->branch->name ?? '—' }}</td>
                            <td class="px-6 py-4 text-textSecondary">
                                {{ $user->roles->pluck('name')->implode(', ') ?: 'No roles' }}
                            </td>
                            <td class="px-6 py-4 text-center">
                                @if($user->is_online)
                                    <span class="badge-pill bg-emerald-50 text-emerald-600 text-xs">Online</span>
                                @else
                                    <span class="badge-pill bg-slate-100 text-slate-500 text-xs">Offline</span>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="px-6 py-8 text-center text-textSecondary">No users found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

</x-app-layout>
