<x-app-layout title="Purchase Orders">

    <div class="flex justify-between items-center mb-6">
        <h1 class="text-xl font-semibold">Purchase Orders</h1>

        @can('purchases.create')
            <a href="{{ route('purchases.create') }}"
               class="bg-primary text-white px-4 py-2 rounded-lg">
                + New Purchase Order
            </a>
        @endcan
    </div>

    <div class="bg-white p-6 rounded-xl shadow border">
        <table class="w-full text-sm">
            <thead>
                <tr class="text-left text-textSecondary border-b">
                    <th class="py-2">PO Number</th>
                    <th class="py-2">Supplier</th>
                    <th class="py-2">Type</th>
                    <th class="py-2">Total</th>
                    <th class="py-2">Status</th>
                    <th class="py-2">Date</th>
                    <th></th>
                </tr>
            </thead>

            <tbody>
                @foreach ($purchases as $p)
                    <tr class="border-b">
                        <td class="py-3 font-medium">{{ $p->po_number }}</td>
                        <td>{{ $p->supplier->name }}</td>
                        <td class="capitalize">{{ $p->purchase_type ?? 'phone' }}</td>
                        <td>${{ number_format($p->total_amount, 2) }}</td>
                        <td>
                            @if($p->status == 'pending')
                                <span class="text-yellow-600">Pending</span>
                            @elseif($p->status == 'received')
                                <span class="text-green-600">Received</span>
                            @elseif($p->status == 'partial')
                                <span class="text-blue-600">Partial</span>
                            @else
                                <span class="text-red-600">Cancelled</span>
                            @endif
                        </td>
                        <td>{{ $p->purchase_date }}</td>
                        <td>
                            <a href="{{ route('purchases.show', $p->id) }}"
                               class="text-primary">View</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>

        </table>

        <div class="mt-4">
            {{ $purchases->links() }}
        </div>

    </div>

</x-app-layout>
