<x-app-layout title="New Purchase Order">

    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Purchases</p>
            <h1 class="text-3xl font-semibold mt-2">Create Purchase Order</h1>
        </div>
        <a href="{{ route('purchases.index') }}" class="text-primary hover:underline text-sm"><- Back to list</a>
    </div>

    @php
        $variationMeta = $variations->map(function ($variation) {
            return [
                'id' => $variation->id,
                'product_id' => $variation->product_id,
                'product_name' => optional($variation->product)->name,
                'sku' => $variation->sku,
                'color' => $variation->color,
                'storage' => $variation->storage,
                'serial_number' => $variation->serial_number,
            ];
        })->values();

        $computerMeta = $computerProducts->map(function ($computer) {
            return [
                'id' => $computer->id,
                'product_code' => $computer->product_code,
                'name' => $computer->name,
                'serial_number' => $computer->serial_number,
                'display' => $computer->display,
                'cpu' => $computer->cpu,
                'capacity' => $computer->capacity,
                'ram' => $computer->ram,
                'storage' => $computer->storage,
                'color' => $computer->color,
                'total_cost' => $computer->total_cost,
            ];
        })->values();

        $phoneSerialMap = $variations->mapWithKeys(function ($variation) {
            if (! $variation->serial_number) {
                return [];
            }
            return [$variation->serial_number => ['id' => $variation->id]];
        });

        $computerSerialMap = $computerProducts->mapWithKeys(function ($computer) {
            if (! $computer->serial_number) {
                return [];
            }
            return [$computer->serial_number => ['id' => $computer->id]];
        });

        $purchaseFormPayload = [
            'purchaseCode' => old('purchase_code', $purchaseCode),
            'sInvoiceNumber' => old('s_invoice_number', $sInvoiceNumber),
            'variations' => $variationMeta,
            'computers' => $computerMeta,
            'phoneSerialMap' => $phoneSerialMap,
            'computerSerialMap' => $computerSerialMap,
            'oldItems' => old('items', []),
            'defaults' => [
                'tax_amount' => old('tax_amount', 0),
                'other_charges' => old('other_charges', 0),
            ],
            'oldSupplier' => old('supplier_id'),
            'purchaseType' => old('purchase_type', 'phone'),
        ];
    @endphp

    <form action="{{ route('purchases.store') }}" method="POST" class="mt-8 space-y-6" x-data='purchaseForm(@json($purchaseFormPayload))'>
        @csrf

        <div class="space-y-6">
            <div class="glass-card rounded-3xl p-6 space-y-5">
                <div class="space-y-1">
                    <h2 class="text-lg font-semibold">Information</h2>
                    <p class="text-sm text-textSecondary">Capture supplier orders and track inbound stock.</p>
                </div>

                <div class="grid md:grid-cols-3 gap-4">
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Purchase ID</label>
                        <input type="text"
                               value="{{ old('purchase_code', $purchaseCode) }}"
                               x-bind:value="purchaseCode"
                               readonly
                               class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary">
                        <input type="hidden" name="purchase_code" value="{{ old('purchase_code', $purchaseCode) }}" x-bind:value="purchaseCode">
                        <p class="text-xs text-textSecondary mt-1">Auto generated from current datetime.</p>
                    </div>
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Invoice Number</label>
                        <input type="text" name="invoice_number" value="{{ old('invoice_number') }}"
                               class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                               placeholder="Optional supplier invoice">
                    </div>
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">S-Invoice</label>
                        <input type="text"
                               value="{{ old('s_invoice_number', $sInvoiceNumber) }}"
                               x-bind:value="sInvoiceNumber"
                               readonly
                               class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary">
                        <input type="hidden" name="s_invoice_number" value="{{ old('s_invoice_number', $sInvoiceNumber) }}" x-bind:value="sInvoiceNumber">
                        <p class="text-xs text-textSecondary mt-1">Format: YearMonthDayHourMinute.</p>
                    </div>
                </div>

                <div class="grid md:grid-cols-3 gap-4">
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Supplier</label>
                        <select name="supplier_id"
                                x-model="supplierId"
                                class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                required>
                            <option value="">Select supplier</option>
                            @foreach($suppliers as $supplier)
                                <option value="{{ $supplier->id }}" @selected(old('supplier_id') == $supplier->id)>{{ $supplier->name }}</option>
                            @endforeach
                        </select>
                        @if($suppliers->isEmpty())
                            <p class="text-xs text-red-500 mt-2">Add a supplier first to create purchase orders.</p>
                        @endif
                        <p class="text-xs text-textSecondary mt-1" x-show="supplierId">
                            Supplier ID: <span class="font-semibold" x-text="supplierId"></span>
                        </p>
                    </div>
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Purchase Date</label>
                        <input type="date" name="purchase_date" value="{{ now()->toDateString() }}"
                               class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                    </div>
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Purchase Type</label>
                        <select name="purchase_type"
                                x-model="purchaseType"
                                @change="resetItemsForType"
                                class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                required>
                            <option value="">Select type</option>
                            <option value="computer" @selected(old('purchase_type') === 'computer')>Computer</option>
                            <option value="phone" @selected(old('purchase_type') === 'phone')>Phone</option>
                        </select>
                    </div>
                </div>
            </div>

            <div class="glass-card rounded-3xl p-6 space-y-4">
                <div class="flex items-center justify-between">
                    <div>
                        <h2 class="text-lg font-semibold">Product Details</h2>
                        <p class="text-sm text-textSecondary">Add each SKU, quantity, and cost.</p>
                    </div>
                    <button type="button" class="px-4 py-2 rounded-2xl bg-primary text-white text-sm shadow shadow-primary/30" @click="addItem">
                        + Add Item
                    </button>
                </div>

                <template x-for="(item, index) in items" :key="item.uid">
                    <div class="rounded-2xl border border-white/60 bg-white/75 p-4 space-y-3">
                        <div class="flex items-start justify-between gap-4">
                            <div class="flex-1 space-y-3">
                                <div>
                                    <template x-if="purchaseType === 'phone'">
                                        <div>
                                            <label class="text-sm text-textSecondary font-medium mb-1 block">Product / SKU</label>
                                            <select x-model="item.variation_id"
                                                    :name="`items[${index}][variation_id]`"
                                                    @change="syncSelection(item)"
                                                    class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                                    :required="purchaseType === 'phone'">
                                                <option value="">Select SKU</option>
                                                @foreach($variations as $variation)
                                                    <option value="{{ $variation->id }}">
                                                        {{ optional($variation->product)->name ?? 'Product #'.$variation->product_id }} - SKU {{ $variation->sku }}
                                                        @if($variation->color || $variation->storage)
                                                            ({{ collect([$variation->color, $variation->storage])->filter()->join(' / ') }})
                                                        @endif
                                                    </option>
                                                @endforeach
                                            </select>
                                            <p class="text-xs text-textSecondary mt-1" x-show="item.product_id">
                                                Product ID:
                                                <span class="font-semibold" x-text="item.product_id"></span>
                                            </p>
                                        </div>
                                    </template>
                                    <template x-if="purchaseType === 'computer'">
                                        <div>
                                            <label class="text-sm text-textSecondary font-medium mb-1 block">Computer Product</label>
                                            <select x-model="item.computer_product_id"
                                                    :name="`items[${index}][computer_product_id]`"
                                                    @change="syncSelection(item)"
                                                    class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                                    :required="purchaseType === 'computer'">
                                                <option value="">Select computer</option>
                                                @foreach($computerProducts as $computer)
                                                    <option value="{{ $computer->id }}">
                                                        {{ $computer->name }} ({{ $computer->serial_number }})
                                                    </option>
                                                @endforeach
                                            </select>
                                            <p class="text-xs text-textSecondary mt-1" x-show="item.meta">
                                                Product Code:
                                                <span class="font-semibold" x-text="item.meta?.product_code"></span>
                                            </p>
                                        </div>
                                    </template>
                                </div>

                                <div class="grid md:grid-cols-2 gap-3">
                                    <div>
                                        <label class="text-sm text-textSecondary font-medium mb-1 block">Serial Number (SN)</label>
                                        <input type="text"
                                               x-model="item.serial_number"
                                               :list="purchaseType === 'computer' ? 'computer-serials' : 'phone-serials'"
                                               @change="handleSerialInput(item)"
                                               :name="`items[${index}][serial_number]`"
                                               class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                               placeholder="Select or search serial">
                                    </div>
                                <div class="rounded-2xl border border-white/60 bg-white/70 px-4 py-3" x-show="item.details">
                                        <template x-if="purchaseType === 'phone'">
                                            <div>
                                                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">SKU</p>
                                                <p class="font-semibold" x-text="item.details?.sku || '-'"></p>
                                                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary mt-2">Color / Storage</p>
                                                <p class="font-medium" x-text="formatVariant(item.details)"></p>
                                            </div>
                                        </template>
                                        <template x-if="purchaseType === 'computer'">
                                            <div class="space-y-1">
                                                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Display / CPU</p>
                                                <p class="font-semibold" x-text="formatComputerMain(item.details)"></p>
                                                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Capacity / RAM / Storage</p>
                                                <p class="font-medium" x-text="formatComputerSpec(item.details)"></p>
                                            </div>
                                        </template>
                                    </div>
                                </div>
                            </div>
                            <button type="button" class="text-sm text-red-500 hover:underline" @click="removeItem(index)" x-show="items.length > 1">
                                Remove
                            </button>
                        </div>

                        <div class="grid md:grid-cols-4 gap-4">
                            <div>
                                <label class="text-sm text-textSecondary font-medium mb-1 block">Quantity</label>
                                <input type="number" min="1"
                                       x-model.number="item.qty"
                                       :name="`items[${index}][qty]`"
                                       class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                       required>
                            </div>
                            <div>
                                <label class="text-sm text-textSecondary font-medium mb-1 block">Cost Price</label>
                                <input type="number" min="0" step="0.01"
                                       x-model.number="item.cost_price"
                                       :name="`items[${index}][cost_price]`"
                                       class="w-full rounded-2xl border border-borderColor/60 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                                       required>
                            </div>
                            <div class="md:col-span-2">
                                <label class="text-sm text-textSecondary font-medium mb-1 block">Product Snapshot</label>
                                <div class="rounded-2xl border border-white/60 bg-white/70 px-4 py-3 space-y-1" x-show="item.details">
                                    <p class="font-semibold" x-text="purchaseType === 'computer' ? (item.details?.name || 'Product details') : (item.details?.product_name || 'Product details')"></p>
                                    <p class="text-sm text-textSecondary" x-text="buildDetails(item.details)"></p>
                                </div>
                                <div class="rounded-2xl border border-white/60 bg-white/60 px-4 py-3 text-sm text-textSecondary" x-show="!item.details">
                                    Select a product/SKU to view details.
                                </div>
                            </div>
                        </div>
                    </div>
                </template>

                @if ($errors->any())
                    <div class="rounded-2xl bg-red-50 border border-red-200 text-sm text-red-600 px-4 py-3">
                        <ul class="list-disc list-inside space-y-1">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
            </div>

            <div class="glass-card rounded-3xl p-6 space-y-5">
                <h2 class="text-lg font-semibold">Summary</h2>
                <div class="flex items-center justify-between">
                    <span class="text-textSecondary">Line Items</span>
                    <span class="font-semibold" x-text="items.length"></span>
                </div>
                <div class="space-y-3">
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Tax</label>
                        <input type="number" min="0" step="0.01"
                               name="tax_amount"
                               x-model.number="taxAmount"
                               value="{{ old('tax_amount', 0) }}"
                               class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                               placeholder="0.00">
                    </div>
                    <div>
                        <label class="text-sm text-textSecondary font-medium mb-1 block">Other Charges</label>
                        <input type="number" min="0" step="0.01"
                               name="other_charges"
                               x-model.number="otherCharges"
                               value="{{ old('other_charges', 0) }}"
                               class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                               placeholder="0.00">
                    </div>
                    <div class="rounded-2xl bg-white/70 border border-white/60 px-4 py-3">
                        <p class="text-sm text-textSecondary">Total Amount</p>
                        <p class="text-2xl font-semibold" x-text="formatCurrency(totalAmount)"></p>
                    </div>
                    <div class="rounded-2xl bg-primary/10 border border-primary/30 px-4 py-3">
                        <p class="text-sm text-textSecondary">Total Amount Due</p>
                        <p class="text-2xl font-semibold" x-text="formatCurrency(totalDue)"></p>
                    </div>
                    <input type="hidden" name="total_due" value="{{ old('total_due', 0) }}" x-bind:value="totalDue.toFixed(2)">
                </div>
            </div>

            <div class="flex justify-end">
                <button type="submit"
                        class="px-8 py-3 rounded-2xl bg-gradient-to-r from-primary to-primaryDark text-white shadow-lg shadow-primary/40">
                    Save Purchase Order
                </button>
            </div>
        </div>
    </form>

    <datalist id="phone-serials">
        @foreach($variations as $variation)
            @if($variation->serial_number)
                <option value="{{ $variation->serial_number }}">
                    {{ optional($variation->product)->name ?? 'Product #'.$variation->product_id }}
                </option>
            @endif
        @endforeach
    </datalist>

    <datalist id="computer-serials">
        @foreach($computerProducts as $computer)
            @if($computer->serial_number)
                <option value="{{ $computer->serial_number }}">{{ $computer->name }}</option>
            @endif
        @endforeach
    </datalist>

    @push('scripts')
        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.data('purchaseForm', (payload = {}) => {
                    const defaults = payload.defaults || {};
                    return {
                        purchaseType: payload.purchaseType || 'phone',
                        purchaseCode: payload.purchaseCode || '',
                        sInvoiceNumber: payload.sInvoiceNumber || '',
                        supplierId: payload.oldSupplier || '',
                        variationMeta: payload.variations || [],
                        computerMeta: payload.computers || [],
                        phoneSerialMap: payload.phoneSerialMap || {},
                        computerSerialMap: payload.computerSerialMap || {},
                        taxAmount: Number(defaults.tax_amount ?? 0),
                        otherCharges: Number(defaults.other_charges ?? 0),
                        items: [],
                        init() {
                            const previousItems = Array.isArray(payload.oldItems) ? payload.oldItems : [];
                            if (previousItems.length) {
                                this.items = previousItems.map(item => this.hydrateItem(item));
                            } else {
                                this.items = [this.newItem()];
                            }
                            this.$watch('purchaseType', () => this.resetItemsForType());
                        },
                        uid() {
                            return (Date.now().toString(36) + Math.random().toString(36).slice(2, 7));
                        },
                        hydrateItem(data) {
                            const variationId = data.variation_id ?? '';
                            const computerId = data.computer_product_id ?? '';
                            const meta = this.lookupMeta(variationId, computerId);
                            return {
                                uid: this.uid(),
                                variation_id: variationId,
                                computer_product_id: computerId,
                                qty: Number(data.qty ?? 1),
                                cost_price: Number(data.cost_price ?? 0),
                                serial_number: data.serial_number ?? '',
                                product_id: meta?.product_id || null,
                                details: meta || null,
                            };
                        },
                        newItem() {
                            return {
                                uid: this.uid(),
                                variation_id: '',
                                computer_product_id: '',
                                qty: 1,
                                cost_price: 0,
                                serial_number: '',
                                product_id: null,
                                details: null,
                            };
                        },
                        lookupMeta(variationId, computerId) {
                            if (this.purchaseType === 'computer') {
                                if (!computerId) return null;
                                return this.computerMeta.find(c => String(c.id) === String(computerId)) || null;
                            }
                            if (!variationId) {
                                return null;
                            }
                            return this.variationMeta.find(v => String(v.id) === String(variationId)) || null;
                        },
                        syncSelection(item) {
                            const meta = this.lookupMeta(item.variation_id, item.computer_product_id);
                            item.product_id = meta?.product_id || null;
                            item.details = meta || null;
                            if (this.purchaseType === 'computer' && meta?.total_cost) {
                                item.cost_price = Number(meta.total_cost) || item.cost_price;
                            }
                        },
                        handleSerialInput(item) {
                            if (this.purchaseType === 'computer') {
                                const record = this.computerSerialMap[item.serial_number];
                                item.computer_product_id = record ? record.id : '';
                            } else {
                                const record = this.phoneSerialMap[item.serial_number];
                                item.variation_id = record ? record.id : '';
                            }
                            this.syncSelection(item);
                        },
                        addItem() {
                            this.items.push(this.newItem());
                        },
                        removeItem(index) {
                            if (this.items.length === 1) return;
                            this.items.splice(index, 1);
                        },
                        resetItemsForType() {
                            this.items = [this.newItem()];
                        },
                        formatCurrency(value) {
                            const number = Number(value) || 0;
                            return new Intl.NumberFormat('en-US', {
                                style: 'currency',
                                currency: 'USD'
                            }).format(number);
                        },
                        formatVariant(details) {
                            if (!details) return '-';
                            return [details.color, details.storage].filter(Boolean).join(' / ') || '-';
                        },
                        formatComputerMain(details) {
                            if (!details) return '-';
                            return [details.display, details.cpu].filter(Boolean).join(' • ') || '-';
                        },
                        formatComputerSpec(details) {
                            if (!details) return '-';
                            return [details.capacity, details.ram, details.storage].filter(Boolean).join(' / ') || '-';
                        },
                        buildDetails(details) {
                            if (!details) return '';
                            const isComputer = this.purchaseType === 'computer';
                            const parts = isComputer
                                ? [
                                    details.name,
                                    details.product_code ? `Code ${details.product_code}` : null,
                                    this.formatComputerMain(details),
                                    this.formatComputerSpec(details),
                                  ]
                                : [
                                    details.product_name,
                                    details.sku ? `SKU ${details.sku}` : null,
                                    this.formatVariant(details)
                                  ];
                            return parts.filter(Boolean).join(' • ');
                        },
                        get totalAmount() {
                            return this.items.reduce((total, item) => {
                                return total + ((Number(item.qty) || 0) * (Number(item.cost_price) || 0));
                            }, 0);
                        },
                        get totalDue() {
                            return this.totalAmount + (Number(this.taxAmount) || 0) + (Number(this.otherCharges) || 0);
                        }
                    };
                });
            });
        </script>
    @endpush

</x-app-layout>
