<x-app-layout title="Dashboard">

    <div class="flex flex-col md:flex-row md:items-end md:justify-between gap-4">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Overview</p>
            <h1 class="text-3xl font-semibold mt-2">Performance Snapshot</h1>
            <p class="text-sm text-textSecondary mt-1">Real-time health for {{ auth()->user()->branch?->name ?? 'all branches' }}</p>
        </div>
        <div class="badge-pill bg-primary/10 text-primary animate-soft-bounce">
            Updated {{ now()->format('g:i A') }}
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-6 mt-8">
        @php
            $cards = [
                ['label' => 'Sales Today', 'value' => $todaySales, 'accent' => 'from-green-400 to-emerald-500'],
                ['label' => 'Purchases Today', 'value' => $todayPurchases, 'accent' => 'from-cyan-400 to-blue-500'],
                ['label' => 'Expenses Today', 'value' => $todayExpenses, 'accent' => 'from-amber-400 to-orange-500'],
                ['label' => 'Profit Today', 'value' => $profitToday, 'accent' => 'from-purple-400 to-indigo-500'],
            ];
        @endphp

        @foreach($cards as $card)
            <div class="glass-card rounded-3xl p-6 card-hover">
                <p class="text-xs uppercase tracking-[0.4em] text-textSecondary">{{ $card['label'] }}</p>
                <div class="mt-4 flex items-end justify-between">
                    <h2 class="text-3xl font-semibold">${{ number_format($card['value'], 2) }}</h2>
                    <span class="inline-flex h-10 w-10 rounded-2xl bg-gradient-to-br {{ $card['accent'] }} text-white items-center justify-center shadow-lg">
                        ⚡
                    </span>
                </div>
                <div class="h-1 mt-6 rounded-full bg-gradient-to-r {{ $card['accent'] }}"></div>
            </div>
        @endforeach
    </div>

    <div class="mt-12 grid md:grid-cols-2 gap-6">
        <div class="glass-card rounded-3xl p-6 card-hover">
            <div class="flex items-center justify-between">
                <div>
                    <h2 class="text-xl font-semibold">Lifetime Purchases</h2>
                    <p class="text-sm text-textSecondary mt-1">All time spend for this branch</p>
                </div>
                <span class="badge-pill bg-slate-100 text-textSecondary">Total Purchases</span>
            </div>
            <div class="mt-6 text-4xl font-semibold">${{ number_format($totalPurchases, 2) }}</div>
        </div>

        {{-- Low Stock --}}
        <div class="glass-card rounded-3xl p-6 card-hover">
            <div class="flex items-center justify-between">
                <div>
                    <h2 class="text-xl font-semibold">Low Stock Alerts</h2>
                    <p class="text-sm text-textSecondary mt-1">Variations trending below threshold (5 units)</p>
                </div>
                <span class="badge-pill bg-red-50 text-red-500">
                    {{ $stockLow->count() }} alerts
                </span>
            </div>

            <div class="mt-6 space-y-4 divide-y divide-white/60">
                @forelse ($stockLow as $item)
                    <div class="pt-4 first:pt-0 flex items-center justify-between text-sm w-full">
                        <div>
                            <p class="font-semibold text-textPrimary">Variation #{{ $item->variation_id }}</p>
                            <p class="text-textSecondary text-xs">Available qty: {{ $item->qty }}</p>
                        </div>
                        <span class="badge-pill bg-red-100 text-red-600">Restock soon</span>
                    </div>
                @empty
                    <p class="text-sm text-textSecondary mt-4">Inventory looks healthy right now 🎉</p>
                @endforelse
            </div>
        </div>
    </div>

    <div class="mt-12 glass-card rounded-3xl p-6 card-hover">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-xl font-semibold">Low Stock Alerts</h2>
                <p class="text-sm text-textSecondary mt-1">Variations trending below threshold (5 units)</p>
            </div>
            <span class="badge-pill bg-red-50 text-red-500">
                {{ $stockLow->count() }} alerts
            </span>
        </div>

        <div class="mt-6 space-y-4 divide-y divide-white/60">
            @forelse ($stockLow as $item)
                <div class="pt-4 first:pt-0 flex items-center justify-between text-sm w-full">
                    <div>
                        <p class="font-semibold text-textPrimary">Variation #{{ $item->variation_id }}</p>
                        <p class="text-textSecondary text-xs">Available qty: {{ $item->qty }}</p>
                    </div>
                    <span class="badge-pill bg-red-100 text-red-600">Restock soon</span>
                </div>
            @empty
                <p class="text-sm text-textSecondary mt-4">Inventory looks healthy right now 🎉</p>
            @endforelse
        </div>
    </div>

</x-app-layout>
