<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run()
    {
        $users = [
            [
                'name' => 'Super Admin',
                'email' => 'admin@system.com',
                'role' => ['Admin'],
                'password' => 'Admin@168',
            ],
            [
                'name' => 'Main Manager',
                'email' => 'manager@system.com',
                'role' => ['Manager'],
                'password' => 'Manager@168',
            ],
            [
                'name' => 'Sales Lead',
                'email' => 'sales@system.com',
                'role' => ['Sales'],
                'password' => 'Sales@168',
            ],
            [
                'name' => 'Tech Specialist',
                'email' => 'technician@system.com',
                'role' => ['Technician'],
                'password' => 'Technician@168',
            ],
            [
                'name' => 'Finance Officer',
                'email' => 'accountant@system.com',
                'role' => ['Accountant'],
                'password' => 'Accountant@168',
            ],
            [
                'name' => 'Multirole User',
                'email' => 'multirole@system.com',
                'role' => ['Manager', 'Sales', 'Technician', 'Accountant'],
                'password' => 'Multi@168',
            ],
        ];

        foreach ($users as $data) {
            $user = \App\Models\User::updateOrCreate(
                ['email' => $data['email']],
                [
                    'name' => $data['name'],
                    'password' => Hash::make($data['password']),
                    'branch_id' => 1,
                ]
            );

            $user->syncRoles($data['role']);
        }
    }
}
