<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->decimal('amount', 12, 2)->nullable()->after('total_amount');
            $table->decimal('profit', 12, 2)->nullable()->after('amount');
            $table->time('paid_time')->nullable()->after('profit');
            $table->text('other')->nullable()->after('paid_time');
            $table->decimal('tax', 12, 2)->nullable()->after('other');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->dropColumn(['tax', 'other', 'paid_time', 'profit', 'amount']);
        });
    }
};
