<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
{
    Schema::create('settlements', function (Blueprint $table) {
        $table->id();
        $table->unsignedBigInteger('branch_id');
        $table->date('date');
        $table->decimal('opening_balance', 12, 2);
        $table->decimal('cash_in', 12, 2)->default(0);
        $table->decimal('cash_out', 12, 2)->default(0);
        $table->decimal('closing_balance', 12, 2);
        $table->timestamps();

        $table->foreign('branch_id')->references('id')->on('branches');
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settlements');
    }
};
