<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
{
    Schema::create('stock_movements', function (Blueprint $table) {
        $table->id();
        $table->unsignedBigInteger('branch_id');
        $table->unsignedBigInteger('variation_id');
        $table->enum('type', ['purchase', 'sale', 'transfer_in', 'transfer_out', 'adjustment']);
        $table->integer('qty');
        $table->string('reference')->nullable();
        $table->timestamps();

        $table->foreign('branch_id')->references('id')->on('branches');
        $table->foreign('variation_id')->references('id')->on('product_variations');
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stock_movements');
    }
};
