<?php

namespace App\Services;

use Kreait\Firebase\Factory;

class FirebaseService
{
    protected $db;
    protected $firestore;

    public function __construct()
    {
        $factory = (new Factory)
            ->withServiceAccount(config('services.firebase.credentials'))
            ->withDatabaseUri(config('services.firebase.database_url'));

        $this->db = $factory->createDatabase();
        $this->firestore = $factory->createFirestore()->database();
    }

    // ------------------------------
    // REALTIME DATABASE
    // ------------------------------
    public function updateStock($variationId, $branchId, $qty)
    {
        $this->db->getReference("stock/{$branchId}/{$variationId}")
            ->set($qty);
    }

    public function logSale($invoiceNumber, array $data)
    {
        $this->db->getReference("sales/{$invoiceNumber}")
            ->set($data);
    }

    // ------------------------------
    // FIRESTORE (Optional)
    // ------------------------------
    public function addDocument($collection, $data)
    {
        $this->firestore->collection($collection)->add($data);
    }
}
