<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        \App\Events\StockUpdated::class => [
            \App\Listeners\SyncStockToFirebase::class,
        ],
        \App\Events\SaleCreated::class => [
            \App\Listeners\SyncSaleToFirebase::class,
        ],
    ];
}