<?php

namespace App\Http\Controllers;

use App\Models\ProductVariation;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class VariationController extends Controller
{
    public function store(Request $request)
    {
        $colorOptions = config('products.colors', ['Black', 'Silver', 'White']);
        $storageOptions = config('products.storages', ['32GB', '64GB', '128GB', '256GB', '512GB', '1TB']);
        $conditionOptions = array_keys(config('products.conditions', ['SC' => 'SC', 'New' => 'New']));
        $networkOptions = array_keys(config('products.network_statuses', ['AT' => 'AT', 'NT' => 'NT']));

        $validated = $request->validate([
            'product_id' => 'required|exists:products,id',
            'color' => ['required', 'string', 'max:255', Rule::in($colorOptions)],
            'storage' => ['nullable', 'string', 'max:255', Rule::in($storageOptions)],
            'barcode' => 'nullable|string|max:255',
            'imei' => 'nullable|string|max:255|unique:product_variations,imei',
            'serial_number' => 'nullable|string|max:255|unique:product_variations,serial_number',
            'condition' => ['required', Rule::in($conditionOptions)],
            'network_status' => ['nullable', Rule::in($networkOptions)],
        ]);

        $validated['sku'] = ProductVariation::nextSku();

        ProductVariation::create($validated);

        return back()->with('success', 'Variation added');
    }
}
