<?php

namespace App\Http\Controllers;

use App\Models\Expense;
use App\Models\Purchase;
use App\Models\Sale;
use App\Models\StockMovement;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index()
    {
        $branchId = auth()->user()->branch_id;

        $todaySales = Sale::where('branch_id', $branchId)
            ->whereDate('sale_date', today())
            ->sum('total_amount');
        $todayPurchases = Purchase::where('branch_id', $branchId)
            ->whereDate('purchase_date', today())
            ->sum('total_amount');
        $todayExpenses = Expense::where('branch_id', $branchId)
            ->whereDate('expense_date', today())
            ->sum('amount');
        $profitToday = $todaySales - ($todayPurchases + $todayExpenses);

        $totalPurchases = Purchase::where('branch_id', $branchId)->sum('total_amount');

        $stockLow = StockMovement::select('variation_id', DB::raw('SUM(qty) as qty'))
            ->where('branch_id', $branchId)
            ->groupBy('variation_id')
            ->havingRaw('qty < 5')
            ->get();

        return view('dashboard.index', compact(
            'todaySales',
            'todayPurchases',
            'todayExpenses',
            'profitToday',
            'stockLow',
            'totalPurchases'
        ));
    }
}
